/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.pkcs;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import java.math.BigInteger;
import java.util.Enumeration;

public class RSAPrivateKeyStructure
extends ASN1Object {
    private int a;
    private BigInteger b;
    private BigInteger c;
    private BigInteger d;
    private BigInteger e;
    private BigInteger f;
    private BigInteger g;
    private BigInteger h;
    private BigInteger i;
    private ASN1Sequence j = null;

    public static RSAPrivateKeyStructure getInstance(ASN1TaggedObject obj, boolean explicit) {
        return RSAPrivateKeyStructure.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static RSAPrivateKeyStructure getInstance(Object obj) {
        if (obj instanceof RSAPrivateKeyStructure) {
            return (RSAPrivateKeyStructure)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new RSAPrivateKeyStructure((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory: " + obj.getClass().getName());
    }

    public RSAPrivateKeyStructure(BigInteger modulus, BigInteger publicExponent, BigInteger privateExponent, BigInteger prime1, BigInteger prime2, BigInteger exponent1, BigInteger exponent2, BigInteger coefficient) {
        this.a = 0;
        this.b = modulus;
        this.c = publicExponent;
        this.d = privateExponent;
        this.e = prime1;
        this.f = prime2;
        this.g = exponent1;
        this.h = exponent2;
        this.i = coefficient;
    }

    public RSAPrivateKeyStructure(ASN1Sequence seq) {
        Enumeration enumeration = seq.getObjects();
        ASN1Integer aSN1Integer = (ASN1Integer)enumeration.nextElement();
        int n2 = aSN1Integer.intValueExact();
        if (n2 < 0 || n2 > 1) {
            throw new IllegalArgumentException("wrong version for RSA private key");
        }
        this.a = n2;
        this.b = ((ASN1Integer)enumeration.nextElement()).getValue();
        this.c = ((ASN1Integer)enumeration.nextElement()).getValue();
        this.d = ((ASN1Integer)enumeration.nextElement()).getValue();
        this.e = ((ASN1Integer)enumeration.nextElement()).getValue();
        this.f = ((ASN1Integer)enumeration.nextElement()).getValue();
        this.g = ((ASN1Integer)enumeration.nextElement()).getValue();
        this.h = ((ASN1Integer)enumeration.nextElement()).getValue();
        this.i = ((ASN1Integer)enumeration.nextElement()).getValue();
        if (enumeration.hasMoreElements()) {
            this.j = (ASN1Sequence)enumeration.nextElement();
        }
    }

    public int getVersion() {
        return this.a;
    }

    public BigInteger getModulus() {
        return this.b;
    }

    public BigInteger getPublicExponent() {
        return this.c;
    }

    public BigInteger getPrivateExponent() {
        return this.d;
    }

    public BigInteger getPrime1() {
        return this.e;
    }

    public BigInteger getPrime2() {
        return this.f;
    }

    public BigInteger getExponent1() {
        return this.g;
    }

    public BigInteger getExponent2() {
        return this.h;
    }

    public BigInteger getCoefficient() {
        return this.i;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(10);
        aSN1EncodableVector.add(new ASN1Integer(this.a));
        aSN1EncodableVector.add(new ASN1Integer(this.getModulus()));
        aSN1EncodableVector.add(new ASN1Integer(this.getPublicExponent()));
        aSN1EncodableVector.add(new ASN1Integer(this.getPrivateExponent()));
        aSN1EncodableVector.add(new ASN1Integer(this.getPrime1()));
        aSN1EncodableVector.add(new ASN1Integer(this.getPrime2()));
        aSN1EncodableVector.add(new ASN1Integer(this.getExponent1()));
        aSN1EncodableVector.add(new ASN1Integer(this.getExponent2()));
        aSN1EncodableVector.add(new ASN1Integer(this.getCoefficient()));
        if (this.j != null) {
            aSN1EncodableVector.add(this.j);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

