/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.sec;

import com.enterprisedt.bouncycastle.asn1.ASN1BitString;
import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.util.Enumeration;

public class ECPrivateKey
extends ASN1Object {
    private ASN1Sequence a;

    private ECPrivateKey(ASN1Sequence seq) {
        this.a = seq;
    }

    public static ECPrivateKey getInstance(Object obj) {
        if (obj instanceof ECPrivateKey) {
            return (ECPrivateKey)obj;
        }
        if (obj != null) {
            return new ECPrivateKey(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public ECPrivateKey(BigInteger key) {
        this(key.bitLength(), key);
    }

    public ECPrivateKey(int orderBitLength, BigInteger key) {
        byte[] byArray = BigIntegers.asUnsignedByteArray((orderBitLength + 7) / 8, key);
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(2);
        aSN1EncodableVector.add(new ASN1Integer(1L));
        aSN1EncodableVector.add(new DEROctetString(byArray));
        this.a = new DERSequence(aSN1EncodableVector);
    }

    public ECPrivateKey(BigInteger key, ASN1Encodable parameters) {
        this(key, null, parameters);
    }

    public ECPrivateKey(BigInteger key, ASN1BitString publicKey, ASN1Encodable parameters) {
        this(key.bitLength(), key, publicKey, parameters);
    }

    public ECPrivateKey(int orderBitLength, BigInteger key, ASN1Encodable parameters) {
        this(orderBitLength, key, null, parameters);
    }

    public ECPrivateKey(int orderBitLength, BigInteger key, ASN1BitString publicKey, ASN1Encodable parameters) {
        byte[] byArray = BigIntegers.asUnsignedByteArray((orderBitLength + 7) / 8, key);
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(4);
        aSN1EncodableVector.add(new ASN1Integer(1L));
        aSN1EncodableVector.add(new DEROctetString(byArray));
        if (parameters != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 0, parameters));
        }
        if (publicKey != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 1, (ASN1Encodable)publicKey));
        }
        this.a = new DERSequence(aSN1EncodableVector);
    }

    public BigInteger getKey() {
        ASN1OctetString aSN1OctetString = (ASN1OctetString)this.a.getObjectAt(1);
        return new BigInteger(1, aSN1OctetString.getOctets());
    }

    public ASN1BitString getPublicKey() {
        return (ASN1BitString)this.a(1, 3);
    }

    public ASN1Primitive getParameters() {
        return this.getParametersObject().toASN1Primitive();
    }

    public ASN1Object getParametersObject() {
        return this.a(0, -1);
    }

    private ASN1Object a(int n2, int n3) {
        Enumeration enumeration = this.a.getObjects();
        while (enumeration.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject;
            ASN1Encodable aSN1Encodable = (ASN1Encodable)enumeration.nextElement();
            if (!(aSN1Encodable instanceof ASN1TaggedObject) || !(aSN1TaggedObject = (ASN1TaggedObject)aSN1Encodable).hasContextTag(n2)) continue;
            return n3 < 0 ? aSN1TaggedObject.getExplicitBaseObject().toASN1Primitive() : aSN1TaggedObject.getBaseUniversal(true, n3);
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.a;
    }
}

