/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.ua;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.ua.DSTU4145BinaryField;
import com.enterprisedt.bouncycastle.asn1.ua.DSTU4145PointEncoder;
import com.enterprisedt.bouncycastle.crypto.params.ECDomainParameters;
import com.enterprisedt.bouncycastle.math.ec.ECAlgorithms;
import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import com.enterprisedt.bouncycastle.math.field.PolynomialExtensionField;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class DSTU4145ECBinary
extends ASN1Object {
    BigInteger a = BigInteger.valueOf(0L);
    DSTU4145BinaryField b;
    ASN1Integer c;
    ASN1OctetString d;
    ASN1Integer e;
    ASN1OctetString f;

    public DSTU4145ECBinary(ECDomainParameters params) {
        ECCurve eCCurve = params.getCurve();
        if (!ECAlgorithms.isF2mCurve(eCCurve)) {
            throw new IllegalArgumentException("only binary domain is possible");
        }
        PolynomialExtensionField polynomialExtensionField = (PolynomialExtensionField)eCCurve.getField();
        int[] nArray = polynomialExtensionField.getMinimalPolynomial().getExponentsPresent();
        if (nArray.length == 3) {
            this.b = new DSTU4145BinaryField(nArray[2], nArray[1]);
        } else if (nArray.length == 5) {
            this.b = new DSTU4145BinaryField(nArray[4], nArray[1], nArray[2], nArray[3]);
        } else {
            throw new IllegalArgumentException("curve must have a trinomial or pentanomial basis");
        }
        this.c = new ASN1Integer(eCCurve.getA().toBigInteger());
        this.d = new DEROctetString(eCCurve.getB().getEncoded());
        this.e = new ASN1Integer(params.getN());
        this.f = new DEROctetString(DSTU4145PointEncoder.encodePoint(params.getG()));
    }

    private DSTU4145ECBinary(ASN1Sequence seq) {
        int n2 = 0;
        if (seq.getObjectAt(n2) instanceof ASN1TaggedObject) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)seq.getObjectAt(n2);
            if (aSN1TaggedObject.isExplicit() && 0 == aSN1TaggedObject.getTagNo()) {
                this.a = ASN1Integer.getInstance(aSN1TaggedObject.getLoadedObject()).getValue();
                ++n2;
            } else {
                throw new IllegalArgumentException("object parse error");
            }
        }
        this.b = DSTU4145BinaryField.getInstance(seq.getObjectAt(n2));
        this.c = ASN1Integer.getInstance(seq.getObjectAt(++n2));
        this.d = ASN1OctetString.getInstance(seq.getObjectAt(++n2));
        this.e = ASN1Integer.getInstance(seq.getObjectAt(++n2));
        this.f = ASN1OctetString.getInstance(seq.getObjectAt(++n2));
    }

    public static DSTU4145ECBinary getInstance(Object obj) {
        if (obj instanceof DSTU4145ECBinary) {
            return (DSTU4145ECBinary)obj;
        }
        if (obj != null) {
            return new DSTU4145ECBinary(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public DSTU4145BinaryField getField() {
        return this.b;
    }

    public BigInteger getA() {
        return this.c.getValue();
    }

    public byte[] getB() {
        return Arrays.clone(this.d.getOctets());
    }

    public BigInteger getN() {
        return this.e.getValue();
    }

    public byte[] getG() {
        return Arrays.clone(this.f.getOctets());
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(6);
        if (0 != this.a.compareTo(BigInteger.valueOf(0L))) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 0, (ASN1Encodable)new ASN1Integer(this.a)));
        }
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        aSN1EncodableVector.add(this.d);
        aSN1EncodableVector.add(this.e);
        aSN1EncodableVector.add(this.f);
        return new DERSequence(aSN1EncodableVector);
    }
}

