/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x500.style;

public class X500NameTokenizer {
    private final String a;
    private final char b;
    private int c;

    public X500NameTokenizer(String oid) {
        this(oid, ',');
    }

    public X500NameTokenizer(String oid, char separator) {
        if (oid == null) {
            throw new NullPointerException();
        }
        if (separator == '\"' || separator == '\\') {
            throw new IllegalArgumentException("reserved separator character");
        }
        this.a = oid;
        this.b = separator;
        this.c = oid.length() < 1 ? 0 : -1;
    }

    public boolean hasMoreTokens() {
        return this.c < this.a.length();
    }

    public String nextToken() {
        if (this.c >= this.a.length()) {
            return null;
        }
        boolean bl = false;
        boolean bl2 = false;
        int n2 = this.c + 1;
        while (++this.c < this.a.length()) {
            char c2 = this.a.charAt(this.c);
            if (bl2) {
                bl2 = false;
                continue;
            }
            if (c2 == '\"') {
                bl = !bl;
                continue;
            }
            if (bl) continue;
            if (c2 == '\\') {
                bl2 = true;
                continue;
            }
            if (c2 != this.b) continue;
            return this.a.substring(n2, this.c);
        }
        if (bl2 || bl) {
            throw new IllegalArgumentException("badly formatted directory string");
        }
        return this.a.substring(n2, this.c);
    }
}

