/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1ParsingException;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x509.Extension;
import com.enterprisedt.bouncycastle.asn1.x509.Extensions;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;

public class ExtensionsGenerator {
    private Hashtable a = new Hashtable();
    private Vector b = new Vector();
    private static final Set c;

    public void reset() {
        this.a = new Hashtable();
        this.b = new Vector();
    }

    public void addExtension(ASN1ObjectIdentifier oid, boolean critical, ASN1Encodable value) throws IOException {
        this.addExtension(oid, critical, value.toASN1Primitive().getEncoded("DER"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addExtension(ASN1ObjectIdentifier oid, boolean critical, byte[] value) {
        if (this.a.containsKey(oid)) {
            if (!c.contains(oid)) throw new IllegalArgumentException("extension " + oid + " already added");
            Extension extension = (Extension)this.a.get(oid);
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(DEROctetString.getInstance(extension.getExtnValue()).getOctets());
            ASN1Sequence aSN1Sequence2 = ASN1Sequence.getInstance(value);
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(aSN1Sequence.size() + aSN1Sequence2.size());
            Enumeration enumeration = aSN1Sequence.getObjects();
            while (enumeration.hasMoreElements()) {
                aSN1EncodableVector.add((ASN1Encodable)enumeration.nextElement());
            }
            enumeration = aSN1Sequence2.getObjects();
            while (enumeration.hasMoreElements()) {
                aSN1EncodableVector.add((ASN1Encodable)enumeration.nextElement());
            }
            try {
                this.a.put(oid, new Extension(oid, critical, new DERSequence(aSN1EncodableVector).getEncoded()));
                return;
            }
            catch (IOException iOException) {
                throw new ASN1ParsingException(iOException.getMessage(), iOException);
            }
        } else {
            this.b.addElement(oid);
            this.a.put(oid, new Extension(oid, critical, (ASN1OctetString)new DEROctetString(Arrays.clone(value))));
        }
    }

    public void addExtension(Extension extension) {
        if (this.a.containsKey(extension.getExtnId())) {
            throw new IllegalArgumentException("extension " + extension.getExtnId() + " already added");
        }
        this.b.addElement(extension.getExtnId());
        this.a.put(extension.getExtnId(), extension);
    }

    public void replaceExtension(ASN1ObjectIdentifier oid, boolean critical, ASN1Encodable value) throws IOException {
        this.replaceExtension(oid, critical, value.toASN1Primitive().getEncoded("DER"));
    }

    public void replaceExtension(ASN1ObjectIdentifier oid, boolean critical, byte[] value) {
        this.replaceExtension(new Extension(oid, critical, value));
    }

    public void replaceExtension(Extension extension) {
        if (!this.a.containsKey(extension.getExtnId())) {
            throw new IllegalArgumentException("extension " + extension.getExtnId() + " not present");
        }
        this.a.put(extension.getExtnId(), extension);
    }

    public void removeExtension(ASN1ObjectIdentifier oid) {
        if (!this.a.containsKey(oid)) {
            throw new IllegalArgumentException("extension " + oid + " not present");
        }
        this.b.removeElement(oid);
        this.a.remove(oid);
    }

    public boolean hasExtension(ASN1ObjectIdentifier oid) {
        return this.a.containsKey(oid);
    }

    public Extension getExtension(ASN1ObjectIdentifier oid) {
        return (Extension)this.a.get(oid);
    }

    public boolean isEmpty() {
        return this.b.isEmpty();
    }

    public Extensions generate() {
        Extension[] extensionArray = new Extension[this.b.size()];
        for (int i2 = 0; i2 != this.b.size(); ++i2) {
            extensionArray[i2] = (Extension)this.a.get(this.b.elementAt(i2));
        }
        return new Extensions(extensionArray);
    }

    public void addExtension(Extensions extensions) {
        ASN1ObjectIdentifier[] aSN1ObjectIdentifierArray = extensions.getExtensionOIDs();
        for (int i2 = 0; i2 != aSN1ObjectIdentifierArray.length; ++i2) {
            ASN1ObjectIdentifier aSN1ObjectIdentifier = aSN1ObjectIdentifierArray[i2];
            Extension extension = extensions.getExtension(aSN1ObjectIdentifier);
            this.addExtension(ASN1ObjectIdentifier.getInstance(aSN1ObjectIdentifier), extension.isCritical(), extension.getExtnValue().getOctets());
        }
    }

    static {
        HashSet<ASN1ObjectIdentifier> hashSet = new HashSet<ASN1ObjectIdentifier>();
        hashSet.add(Extension.subjectAlternativeName);
        hashSet.add(Extension.issuerAlternativeName);
        hashSet.add(Extension.subjectDirectoryAttributes);
        hashSet.add(Extension.certificateIssuer);
        c = Collections.unmodifiableSet(hashSet);
    }
}

