/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.x509.GeneralName;
import java.math.BigInteger;

public class GeneralSubtree
extends ASN1Object {
    private static final BigInteger a = BigInteger.valueOf(0L);
    private GeneralName b;
    private ASN1Integer c;
    private ASN1Integer d;

    private GeneralSubtree(ASN1Sequence seq) {
        this.b = GeneralName.getInstance(seq.getObjectAt(0));
        block0 : switch (seq.size()) {
            case 1: {
                break;
            }
            case 2: {
                ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(seq.getObjectAt(1));
                switch (aSN1TaggedObject.getTagNo()) {
                    case 0: {
                        this.c = ASN1Integer.getInstance(aSN1TaggedObject, false);
                        break block0;
                    }
                    case 1: {
                        this.d = ASN1Integer.getInstance(aSN1TaggedObject, false);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Bad tag number: " + aSN1TaggedObject.getTagNo());
            }
            case 3: {
                ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(seq.getObjectAt(1));
                if (aSN1TaggedObject.getTagNo() != 0) {
                    throw new IllegalArgumentException("Bad tag number for 'minimum': " + aSN1TaggedObject.getTagNo());
                }
                this.c = ASN1Integer.getInstance(aSN1TaggedObject, false);
                aSN1TaggedObject = ASN1TaggedObject.getInstance(seq.getObjectAt(2));
                if (aSN1TaggedObject.getTagNo() != 1) {
                    throw new IllegalArgumentException("Bad tag number for 'maximum': " + aSN1TaggedObject.getTagNo());
                }
                this.d = ASN1Integer.getInstance(aSN1TaggedObject, false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad sequence size: " + seq.size());
            }
        }
    }

    public GeneralSubtree(GeneralName base, BigInteger minimum, BigInteger maximum) {
        this.b = base;
        if (maximum != null) {
            this.d = new ASN1Integer(maximum);
        }
        this.c = minimum == null ? null : new ASN1Integer(minimum);
    }

    public GeneralSubtree(GeneralName base) {
        this(base, null, null);
    }

    public static GeneralSubtree getInstance(ASN1TaggedObject o2, boolean explicit) {
        return new GeneralSubtree(ASN1Sequence.getInstance(o2, explicit));
    }

    public static GeneralSubtree getInstance(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof GeneralSubtree) {
            return (GeneralSubtree)obj;
        }
        return new GeneralSubtree(ASN1Sequence.getInstance(obj));
    }

    public GeneralName getBase() {
        return this.b;
    }

    public BigInteger getMinimum() {
        if (this.c == null) {
            return a;
        }
        return this.c.getValue();
    }

    public BigInteger getMaximum() {
        if (this.d == null) {
            return null;
        }
        return this.d.getValue();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(3);
        aSN1EncodableVector.add(this.b);
        if (this.c != null && !this.c.hasValue(0)) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, (ASN1Encodable)this.c));
        }
        if (this.d != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, (ASN1Encodable)this.d));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

