/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.x509.Extension;
import com.enterprisedt.bouncycastle.asn1.x509.Extensions;
import java.math.BigInteger;

public class PolicyConstraints
extends ASN1Object {
    private BigInteger a;
    private BigInteger b;

    public PolicyConstraints(BigInteger requireExplicitPolicyMapping, BigInteger inhibitPolicyMapping) {
        this.a = requireExplicitPolicyMapping;
        this.b = inhibitPolicyMapping;
    }

    private PolicyConstraints(ASN1Sequence seq) {
        for (int i2 = 0; i2 != seq.size(); ++i2) {
            ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(seq.getObjectAt(i2));
            if (aSN1TaggedObject.getTagNo() == 0) {
                this.a = ASN1Integer.getInstance(aSN1TaggedObject, false).getValue();
                continue;
            }
            if (aSN1TaggedObject.getTagNo() == 1) {
                this.b = ASN1Integer.getInstance(aSN1TaggedObject, false).getValue();
                continue;
            }
            throw new IllegalArgumentException("Unknown tag encountered.");
        }
    }

    public static PolicyConstraints getInstance(Object obj) {
        if (obj instanceof PolicyConstraints) {
            return (PolicyConstraints)obj;
        }
        if (obj != null) {
            return new PolicyConstraints(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public static PolicyConstraints fromExtensions(Extensions extensions) {
        return PolicyConstraints.getInstance(Extensions.getExtensionParsedValue(extensions, Extension.policyConstraints));
    }

    public BigInteger getRequireExplicitPolicyMapping() {
        return this.a;
    }

    public BigInteger getInhibitPolicyMapping() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(2);
        if (this.a != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, (ASN1Encodable)new ASN1Integer(this.a)));
        }
        if (this.b != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, (ASN1Encodable)new ASN1Integer(this.b)));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

