/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509.qualified;

import com.enterprisedt.bouncycastle.asn1.ASN1Choice;
import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;

public class TypeOfBiometricData
extends ASN1Object
implements ASN1Choice {
    public static final int PICTURE = 0;
    public static final int HANDWRITTEN_SIGNATURE = 1;
    ASN1Encodable a;

    public static TypeOfBiometricData getInstance(Object obj) {
        if (obj == null || obj instanceof TypeOfBiometricData) {
            return (TypeOfBiometricData)obj;
        }
        if (obj instanceof ASN1Integer) {
            ASN1Integer aSN1Integer = ASN1Integer.getInstance(obj);
            int n2 = aSN1Integer.intValueExact();
            return new TypeOfBiometricData(n2);
        }
        if (obj instanceof ASN1ObjectIdentifier) {
            ASN1ObjectIdentifier aSN1ObjectIdentifier = ASN1ObjectIdentifier.getInstance(obj);
            return new TypeOfBiometricData(aSN1ObjectIdentifier);
        }
        throw new IllegalArgumentException("unknown object in getInstance");
    }

    public TypeOfBiometricData(int predefinedBiometricType) {
        if (predefinedBiometricType != 0 && predefinedBiometricType != 1) {
            throw new IllegalArgumentException("unknow PredefinedBiometricType : " + predefinedBiometricType);
        }
        this.a = new ASN1Integer(predefinedBiometricType);
    }

    public TypeOfBiometricData(ASN1ObjectIdentifier BiometricDataID) {
        this.a = BiometricDataID;
    }

    public boolean isPredefined() {
        return this.a instanceof ASN1Integer;
    }

    public int getPredefinedBiometricType() {
        return ((ASN1Integer)this.a).intValueExact();
    }

    public ASN1ObjectIdentifier getBiometricDataOid() {
        return (ASN1ObjectIdentifier)this.a;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.a.toASN1Primitive();
    }
}

