/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.MultiBlockCipher;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.StreamCipher;

public class BufferedBlockCipher {
    protected byte[] buf;
    protected int bufOff;
    protected boolean forEncryption;
    protected BlockCipher cipher;
    protected MultiBlockCipher mbCipher;
    protected boolean partialBlockOkay;
    protected boolean pgpCFB;

    BufferedBlockCipher() {
    }

    public BufferedBlockCipher(BlockCipher cipher) {
        this.cipher = cipher;
        if (cipher instanceof MultiBlockCipher) {
            this.mbCipher = (MultiBlockCipher)cipher;
            this.buf = new byte[this.mbCipher.getMultiBlockSize()];
        } else {
            this.mbCipher = null;
            this.buf = new byte[cipher.getBlockSize()];
        }
        this.bufOff = 0;
        String string = cipher.getAlgorithmName();
        int n2 = string.indexOf(47) + 1;
        boolean bl = this.pgpCFB = n2 > 0 && string.startsWith("PGP", n2);
        this.partialBlockOkay = this.pgpCFB || cipher instanceof StreamCipher ? true : n2 > 0 && string.startsWith("OpenPGP", n2);
    }

    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        this.forEncryption = forEncryption;
        this.reset();
        this.cipher.init(forEncryption, params);
    }

    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    public int getUpdateOutputSize(int len) {
        int n2 = len + this.bufOff;
        int n3 = this.pgpCFB ? (this.forEncryption ? n2 % this.buf.length - (this.cipher.getBlockSize() + 2) : n2 % this.buf.length) : n2 % this.buf.length;
        return n2 - n3;
    }

    public int getOutputSize(int length) {
        if (this.pgpCFB && this.forEncryption) {
            return length + this.bufOff + (this.cipher.getBlockSize() + 2);
        }
        return length + this.bufOff;
    }

    public int processByte(byte in, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        int n2 = 0;
        this.buf[this.bufOff++] = in;
        if (this.bufOff == this.buf.length) {
            n2 = this.cipher.processBlock(this.buf, 0, out, outOff);
            this.bufOff = 0;
        }
        return n2;
    }

    public int processBytes(byte[] in, int inOff, int len, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        if (len < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        int n2 = this.getBlockSize();
        int n3 = this.getUpdateOutputSize(len);
        if (n3 > 0 && outOff + n3 > out.length) {
            throw new OutputLengthException("output buffer too short");
        }
        int n4 = 0;
        int n5 = this.buf.length - this.bufOff;
        if (len > n5) {
            System.arraycopy(in, inOff, this.buf, this.bufOff, n5);
            n4 += this.cipher.processBlock(this.buf, 0, out, outOff);
            this.bufOff = 0;
            len -= n5;
            inOff += n5;
            if (this.mbCipher != null) {
                int n6 = len / this.mbCipher.getMultiBlockSize();
                if (n6 > 0) {
                    n4 += this.mbCipher.processBlocks(in, inOff, n6, out, outOff + n4);
                    int n7 = n6 * this.mbCipher.getMultiBlockSize();
                    len -= n7;
                    inOff += n7;
                }
            } else {
                while (len > this.buf.length) {
                    n4 += this.cipher.processBlock(in, inOff, out, outOff + n4);
                    len -= n2;
                    inOff += n2;
                }
            }
        }
        System.arraycopy(in, inOff, this.buf, this.bufOff, len);
        this.bufOff += len;
        if (this.bufOff == this.buf.length) {
            n4 += this.cipher.processBlock(this.buf, 0, out, outOff + n4);
            this.bufOff = 0;
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doFinal(byte[] out, int outOff) throws DataLengthException, IllegalStateException, InvalidCipherTextException {
        try {
            int n2 = 0;
            if (outOff + this.bufOff > out.length) {
                throw new OutputLengthException("output buffer too short for doFinal()");
            }
            if (this.bufOff != 0) {
                if (!this.partialBlockOkay) {
                    throw new DataLengthException("data not block size aligned");
                }
                this.cipher.processBlock(this.buf, 0, this.buf, 0);
                n2 = this.bufOff;
                this.bufOff = 0;
                System.arraycopy(this.buf, 0, out, outOff, n2);
            }
            int n3 = n2;
            return n3;
        }
        finally {
            this.reset();
        }
    }

    public void reset() {
        for (int i2 = 0; i2 < this.buf.length; ++i2) {
            this.buf[i2] = 0;
        }
        this.bufOff = 0;
        this.cipher.reset();
    }
}

