/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.agreement;

import com.enterprisedt.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.agreement.a;
import com.enterprisedt.bouncycastle.crypto.generators.DHKeyPairGenerator;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.DHKeyGenerationParameters;
import com.enterprisedt.bouncycastle.crypto.params.DHParameters;
import com.enterprisedt.bouncycastle.crypto.params.DHPrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.DHPublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import java.math.BigInteger;
import java.security.SecureRandom;

public class DHAgreement {
    private static final BigInteger a = BigInteger.valueOf(1L);
    private DHPrivateKeyParameters b;
    private DHParameters c;
    private BigInteger d;
    private SecureRandom e;

    public void init(CipherParameters param) {
        AsymmetricKeyParameter asymmetricKeyParameter;
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)param;
            this.e = parametersWithRandom.getRandom();
            asymmetricKeyParameter = (AsymmetricKeyParameter)parametersWithRandom.getParameters();
        } else {
            this.e = CryptoServicesRegistrar.getSecureRandom();
            asymmetricKeyParameter = (AsymmetricKeyParameter)param;
        }
        if (!(asymmetricKeyParameter instanceof DHPrivateKeyParameters)) {
            throw new IllegalArgumentException("DHEngine expects DHPrivateKeyParameters");
        }
        this.b = (DHPrivateKeyParameters)asymmetricKeyParameter;
        this.c = this.b.getParameters();
        CryptoServicesRegistrar.checkConstraints(com.enterprisedt.bouncycastle.crypto.agreement.a.a("DH", this.b));
    }

    public BigInteger calculateMessage() {
        DHKeyPairGenerator dHKeyPairGenerator = new DHKeyPairGenerator();
        dHKeyPairGenerator.init(new DHKeyGenerationParameters(this.e, this.c));
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = dHKeyPairGenerator.generateKeyPair();
        this.d = ((DHPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()).getX();
        return ((DHPublicKeyParameters)asymmetricCipherKeyPair.getPublic()).getY();
    }

    public BigInteger calculateAgreement(DHPublicKeyParameters pub, BigInteger message) {
        if (!pub.getParameters().equals(this.c)) {
            throw new IllegalArgumentException("Diffie-Hellman public key has wrong parameters.");
        }
        BigInteger bigInteger = this.c.getP();
        BigInteger bigInteger2 = pub.getY();
        if (bigInteger2 == null || bigInteger2.compareTo(a) <= 0 || bigInteger2.compareTo(bigInteger.subtract(a)) >= 0) {
            throw new IllegalArgumentException("Diffie-Hellman public key is weak");
        }
        BigInteger bigInteger3 = bigInteger2.modPow(this.d, bigInteger);
        if (bigInteger3.equals(a)) {
            throw new IllegalStateException("Shared key can't be 1");
        }
        return message.modPow(this.b.getX(), bigInteger).multiply(bigInteger3).mod(bigInteger);
    }
}

