/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.agreement;

import com.enterprisedt.bouncycastle.crypto.BasicAgreement;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.agreement.a;
import com.enterprisedt.bouncycastle.crypto.params.DHMQVPrivateParameters;
import com.enterprisedt.bouncycastle.crypto.params.DHMQVPublicParameters;
import com.enterprisedt.bouncycastle.crypto.params.DHParameters;
import com.enterprisedt.bouncycastle.crypto.params.DHPrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.DHPublicKeyParameters;
import java.math.BigInteger;

public class MQVBasicAgreement
implements BasicAgreement {
    private static final BigInteger b = BigInteger.valueOf(1L);
    DHMQVPrivateParameters a;

    @Override
    public void init(CipherParameters key) {
        this.a = (DHMQVPrivateParameters)key;
        CryptoServicesRegistrar.checkConstraints(com.enterprisedt.bouncycastle.crypto.agreement.a.a("MQV", this.a.getStaticPrivateKey()));
    }

    @Override
    public int getFieldSize() {
        return (this.a.getStaticPrivateKey().getParameters().getP().bitLength() + 7) / 8;
    }

    @Override
    public BigInteger calculateAgreement(CipherParameters pubKey) {
        DHMQVPublicParameters dHMQVPublicParameters = (DHMQVPublicParameters)pubKey;
        DHPrivateKeyParameters dHPrivateKeyParameters = this.a.getStaticPrivateKey();
        if (!this.a.getStaticPrivateKey().getParameters().equals(dHMQVPublicParameters.getStaticPublicKey().getParameters())) {
            throw new IllegalStateException("MQV public key components have wrong domain parameters");
        }
        if (this.a.getStaticPrivateKey().getParameters().getQ() == null) {
            throw new IllegalStateException("MQV key domain parameters do not have Q set");
        }
        BigInteger bigInteger = this.a(dHPrivateKeyParameters.getParameters(), dHPrivateKeyParameters, dHMQVPublicParameters.getStaticPublicKey(), this.a.getEphemeralPrivateKey(), this.a.getEphemeralPublicKey(), dHMQVPublicParameters.getEphemeralPublicKey());
        if (bigInteger.equals(b)) {
            throw new IllegalStateException("1 is not a valid agreement value for MQV");
        }
        return bigInteger;
    }

    private BigInteger a(DHParameters dHParameters, DHPrivateKeyParameters dHPrivateKeyParameters, DHPublicKeyParameters dHPublicKeyParameters, DHPrivateKeyParameters dHPrivateKeyParameters2, DHPublicKeyParameters dHPublicKeyParameters2, DHPublicKeyParameters dHPublicKeyParameters3) {
        BigInteger bigInteger = dHParameters.getQ();
        int n2 = (bigInteger.bitLength() + 1) / 2;
        BigInteger bigInteger2 = BigInteger.valueOf(2L).pow(n2);
        BigInteger bigInteger3 = dHPublicKeyParameters2.getY().mod(bigInteger2).add(bigInteger2);
        BigInteger bigInteger4 = dHPrivateKeyParameters2.getX().add(bigInteger3.multiply(dHPrivateKeyParameters.getX())).mod(bigInteger);
        BigInteger bigInteger5 = dHPublicKeyParameters3.getY().mod(bigInteger2).add(bigInteger2);
        BigInteger bigInteger6 = dHPublicKeyParameters3.getY().multiply(dHPublicKeyParameters.getY().modPow(bigInteger5, dHParameters.getP())).modPow(bigInteger4, dHParameters.getP());
        return bigInteger6;
    }
}

