/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.agreement;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.RawAgreement;
import com.enterprisedt.bouncycastle.crypto.params.XDHUPrivateParameters;
import com.enterprisedt.bouncycastle.crypto.params.XDHUPublicParameters;

public class XDHUnifiedAgreement
implements RawAgreement {
    private final RawAgreement a;
    private XDHUPrivateParameters b;

    public XDHUnifiedAgreement(RawAgreement xAgreement) {
        this.a = xAgreement;
    }

    @Override
    public void init(CipherParameters key) {
        this.b = (XDHUPrivateParameters)key;
        this.a.init(this.b.getStaticPrivateKey());
    }

    @Override
    public int getAgreementSize() {
        return this.a.getAgreementSize() * 2;
    }

    @Override
    public void calculateAgreement(CipherParameters publicKey, byte[] buf, int off) {
        XDHUPublicParameters xDHUPublicParameters = (XDHUPublicParameters)publicKey;
        this.a.init(this.b.getEphemeralPrivateKey());
        this.a.calculateAgreement(xDHUPublicParameters.getEphemeralPublicKey(), buf, off);
        this.a.init(this.b.getStaticPrivateKey());
        this.a.calculateAgreement(xDHUPublicParameters.getStaticPublicKey(), buf, off + this.a.getAgreementSize());
    }
}

