/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.agreement.srp;

import com.enterprisedt.bouncycastle.crypto.CryptoException;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SRP6Util {
    private static BigInteger a = BigInteger.valueOf(0L);
    private static BigInteger b = BigInteger.valueOf(1L);

    public static BigInteger calculateK(Digest digest, BigInteger N, BigInteger g2) {
        return SRP6Util.a(digest, N, N, g2);
    }

    public static BigInteger calculateU(Digest digest, BigInteger N, BigInteger A, BigInteger B) {
        return SRP6Util.a(digest, N, A, B);
    }

    public static BigInteger calculateX(Digest digest, BigInteger N, byte[] salt, byte[] identity, byte[] password) {
        byte[] byArray = new byte[digest.getDigestSize()];
        digest.update(identity, 0, identity.length);
        digest.update((byte)58);
        digest.update(password, 0, password.length);
        digest.doFinal(byArray, 0);
        digest.update(salt, 0, salt.length);
        digest.update(byArray, 0, byArray.length);
        digest.doFinal(byArray, 0);
        return new BigInteger(1, byArray);
    }

    public static BigInteger generatePrivateValue(Digest digest, BigInteger N, BigInteger g2, SecureRandom random) {
        int n2 = Math.min(256, N.bitLength() / 2);
        BigInteger bigInteger = b.shiftLeft(n2 - 1);
        BigInteger bigInteger2 = N.subtract(b);
        return BigIntegers.createRandomInRange(bigInteger, bigInteger2, random);
    }

    public static BigInteger validatePublicValue(BigInteger N, BigInteger val) throws CryptoException {
        if ((val = val.mod(N)).equals(a)) {
            throw new CryptoException("Invalid public value: 0");
        }
        return val;
    }

    public static BigInteger calculateM1(Digest digest, BigInteger N, BigInteger A, BigInteger B, BigInteger S) {
        BigInteger bigInteger = SRP6Util.a(digest, N, A, B, S);
        return bigInteger;
    }

    public static BigInteger calculateM2(Digest digest, BigInteger N, BigInteger A, BigInteger M1, BigInteger S) {
        BigInteger bigInteger = SRP6Util.a(digest, N, A, M1, S);
        return bigInteger;
    }

    public static BigInteger calculateKey(Digest digest, BigInteger N, BigInteger S) {
        int n2 = (N.bitLength() + 7) / 8;
        byte[] byArray = SRP6Util.a(S, n2);
        digest.update(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[digest.getDigestSize()];
        digest.doFinal(byArray2, 0);
        return new BigInteger(1, byArray2);
    }

    private static BigInteger a(Digest digest, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        int n2 = (bigInteger.bitLength() + 7) / 8;
        byte[] byArray = SRP6Util.a(bigInteger2, n2);
        byte[] byArray2 = SRP6Util.a(bigInteger3, n2);
        byte[] byArray3 = SRP6Util.a(bigInteger4, n2);
        digest.update(byArray, 0, byArray.length);
        digest.update(byArray2, 0, byArray2.length);
        digest.update(byArray3, 0, byArray3.length);
        byte[] byArray4 = new byte[digest.getDigestSize()];
        digest.doFinal(byArray4, 0);
        return new BigInteger(1, byArray4);
    }

    private static BigInteger a(Digest digest, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        int n2 = (bigInteger.bitLength() + 7) / 8;
        byte[] byArray = SRP6Util.a(bigInteger2, n2);
        byte[] byArray2 = SRP6Util.a(bigInteger3, n2);
        digest.update(byArray, 0, byArray.length);
        digest.update(byArray2, 0, byArray2.length);
        byte[] byArray3 = new byte[digest.getDigestSize()];
        digest.doFinal(byArray3, 0);
        return new BigInteger(1, byArray3);
    }

    private static byte[] a(BigInteger bigInteger, int n2) {
        byte[] byArray = BigIntegers.asUnsignedByteArray(bigInteger);
        if (byArray.length < n2) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, n2 - byArray.length, byArray.length);
            byArray = byArray2;
        }
        return byArray;
    }
}

