/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.digests;

import com.enterprisedt.bouncycastle.crypto.CryptoServicePurpose;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.ExtendedDigest;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.Xof;
import com.enterprisedt.bouncycastle.crypto.digests.a;
import com.enterprisedt.bouncycastle.crypto.params.Blake3Parameters;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Integers;
import com.enterprisedt.bouncycastle.util.Memoable;
import com.enterprisedt.bouncycastle.util.Pack;
import java.util.Iterator;
import java.util.Stack;

public class Blake3Digest
implements ExtendedDigest,
Xof,
Memoable {
    private static final byte[] a = new byte[]{2, 6, 3, 10, 7, 0, 4, 13, 1, 11, 12, 5, 9, 14, 15, 8};
    private static final int[] b = new int[]{1779033703, -1150833019, 1013904242, -1521486534, 1359893119, -1694144372, 528734635, 1541459225};
    private final byte[] c = new byte[64];
    private final int[] d = new int[8];
    private final int[] e = new int[8];
    private final int[] f = new int[16];
    private final int[] g = new int[16];
    private final byte[] h = new byte[16];
    private final Stack i = new Stack();
    private final int j;
    private boolean k;
    private long l;
    private int m;
    private int n;
    private int o;
    private long p;
    private int q;
    private int r;
    private final CryptoServicePurpose s;

    public Blake3Digest() {
        this(256);
    }

    public Blake3Digest(int pDigestSize) {
        this(pDigestSize > 100 ? pDigestSize : pDigestSize * 8, CryptoServicePurpose.ANY);
    }

    public Blake3Digest(int pDigestSize, CryptoServicePurpose purpose) {
        this.s = purpose;
        this.j = pDigestSize / 8;
        CryptoServicesRegistrar.checkConstraints(com.enterprisedt.bouncycastle.crypto.digests.a.a(this, this.getDigestSize() * 8, purpose));
        this.init(null);
    }

    public Blake3Digest(Blake3Digest pSource) {
        this.j = pSource.j;
        this.s = pSource.s;
        this.reset(pSource);
    }

    @Override
    public int getByteLength() {
        return 64;
    }

    @Override
    public String getAlgorithmName() {
        return "BLAKE3";
    }

    @Override
    public int getDigestSize() {
        return this.j;
    }

    public void init(Blake3Parameters pParams) {
        byte[] byArray = pParams == null ? null : pParams.getKey();
        byte[] byArray2 = pParams == null ? null : pParams.getContext();
        this.reset();
        if (byArray != null) {
            this.a(byArray);
            Arrays.fill(byArray, (byte)0);
        } else if (byArray2 != null) {
            this.h();
            this.m = 32;
            this.update(byArray2, 0, byArray2.length);
            this.doFinal(this.c, 0);
            this.i();
            this.reset();
        } else {
            this.h();
            this.m = 0;
        }
    }

    @Override
    public void update(byte b2) {
        if (this.k) {
            throw new IllegalStateException("Already outputting");
        }
        int n2 = this.c.length;
        int n3 = n2 - this.r;
        if (n3 == 0) {
            this.a(this.c, 0);
            Arrays.fill(this.c, (byte)0);
            this.r = 0;
        }
        this.c[this.r] = b2;
        ++this.r;
    }

    @Override
    public void update(byte[] pMessage, int pOffset, int pLen) {
        int n2;
        if (pMessage == null || pLen == 0) {
            return;
        }
        if (this.k) {
            throw new IllegalStateException("Already outputting");
        }
        int n3 = 0;
        if (this.r != 0) {
            n3 = 64 - this.r;
            if (n3 >= pLen) {
                System.arraycopy(pMessage, pOffset, this.c, this.r, pLen);
                this.r += pLen;
                return;
            }
            System.arraycopy(pMessage, pOffset, this.c, this.r, n3);
            this.a(this.c, 0);
            this.r = 0;
            Arrays.fill(this.c, (byte)0);
        }
        int n4 = pOffset + pLen - 64;
        for (n2 = pOffset + n3; n2 < n4; n2 += 64) {
            this.a(pMessage, n2);
        }
        int n5 = pLen - n2;
        System.arraycopy(pMessage, n2, this.c, 0, pOffset + n5);
        this.r += pOffset + n5;
    }

    @Override
    public int doFinal(byte[] pOutput, int pOutOffset) {
        return this.doFinal(pOutput, pOutOffset, this.getDigestSize());
    }

    @Override
    public int doFinal(byte[] pOut, int pOutOffset, int pOutLen) {
        int n2 = this.doOutput(pOut, pOutOffset, pOutLen);
        this.reset();
        return n2;
    }

    @Override
    public int doOutput(byte[] pOut, int pOutOffset, int pOutLen) {
        int n2;
        if (pOutOffset > pOut.length - pOutLen) {
            throw new OutputLengthException("output buffer too short");
        }
        if (!this.k) {
            this.a(this.r);
        }
        if (pOutLen < 0 || this.l >= 0L && (long)pOutLen > this.l) {
            throw new IllegalArgumentException("Insufficient bytes remaining");
        }
        int n3 = pOutLen;
        int n4 = pOutOffset;
        if (this.r < 64) {
            n2 = Math.min(n3, 64 - this.r);
            System.arraycopy(this.c, this.r, pOut, n4, n2);
            this.r += n2;
            n4 += n2;
            n3 -= n2;
        }
        while (n3 > 0) {
            this.k();
            n2 = Math.min(n3, 64);
            System.arraycopy(this.c, 0, pOut, n4, n2);
            this.r += n2;
            n4 += n2;
            n3 -= n2;
        }
        this.l -= (long)pOutLen;
        return pOutLen;
    }

    @Override
    public void reset() {
        this.m();
        this.r = 0;
        this.k = false;
        Arrays.fill(this.c, (byte)0);
    }

    @Override
    public void reset(Memoable pSource) {
        Blake3Digest blake3Digest = (Blake3Digest)pSource;
        this.p = blake3Digest.p;
        this.q = blake3Digest.q;
        this.m = blake3Digest.m;
        this.k = blake3Digest.k;
        this.l = blake3Digest.l;
        this.n = blake3Digest.n;
        this.o = blake3Digest.o;
        System.arraycopy(blake3Digest.e, 0, this.e, 0, this.e.length);
        System.arraycopy(blake3Digest.d, 0, this.d, 0, this.d.length);
        System.arraycopy(blake3Digest.g, 0, this.g, 0, this.g.length);
        this.i.clear();
        Iterator iterator = blake3Digest.i.iterator();
        while (iterator.hasNext()) {
            this.i.push(Arrays.clone((int[])iterator.next()));
        }
        System.arraycopy(blake3Digest.c, 0, this.c, 0, this.c.length);
        this.r = blake3Digest.r;
    }

    @Override
    public Memoable copy() {
        return new Blake3Digest(this);
    }

    private void a(byte[] byArray, int n2) {
        this.a(64, false);
        this.b(byArray, n2);
        this.c();
        if (this.q == 0) {
            this.a();
        }
    }

    private void a() {
        for (long i2 = this.p; i2 > 0L && (i2 & 1L) != 1L; i2 >>= 1) {
            int[] nArray = (int[])this.i.pop();
            System.arraycopy(nArray, 0, this.g, 0, 8);
            System.arraycopy(this.e, 0, this.g, 8, 8);
            this.j();
            this.c();
        }
        this.i.push(Arrays.copyOf(this.e, 8));
    }

    private void a(int n2) {
        this.a(n2, true);
        this.b(this.c, 0);
        this.c();
        this.b();
    }

    private void b() {
        while (!this.i.isEmpty()) {
            int[] nArray = (int[])this.i.pop();
            System.arraycopy(nArray, 0, this.g, 0, 8);
            System.arraycopy(this.e, 0, this.g, 8, 8);
            this.j();
            if (this.i.isEmpty()) {
                this.n();
            }
            this.c();
        }
    }

    private void c() {
        this.f();
        for (int i2 = 0; i2 < 6; ++i2) {
            this.d();
            this.g();
        }
        this.d();
        this.e();
    }

    private void d() {
        this.a(0, 0, 4, 8, 12);
        this.a(1, 1, 5, 9, 13);
        this.a(2, 2, 6, 10, 14);
        this.a(3, 3, 7, 11, 15);
        this.a(4, 0, 5, 10, 15);
        this.a(5, 1, 6, 11, 12);
        this.a(6, 2, 7, 8, 13);
        this.a(7, 3, 4, 9, 14);
    }

    private void b(byte[] byArray, int n2) {
        Pack.littleEndianToInt(byArray, n2, this.g);
    }

    private void e() {
        if (this.k) {
            for (int i2 = 0; i2 < 8; ++i2) {
                int n2 = i2;
                this.f[n2] = this.f[n2] ^ this.f[i2 + 8];
                int n3 = i2 + 8;
                this.f[n3] = this.f[n3] ^ this.e[i2];
            }
            Pack.intToLittleEndian(this.f, this.c, 0);
            this.r = 0;
        } else {
            for (int i3 = 0; i3 < 8; ++i3) {
                this.e[i3] = this.f[i3] ^ this.f[i3 + 8];
            }
        }
    }

    private void a(int n2, int n3, int n4, int n5, int n6) {
        int n7 = n2 << 1;
        int n8 = n3;
        this.f[n8] = this.f[n8] + (this.f[n4] + this.g[this.h[n7++]]);
        this.f[n6] = Integers.rotateRight(this.f[n6] ^ this.f[n3], 16);
        int n9 = n5;
        this.f[n9] = this.f[n9] + this.f[n6];
        this.f[n4] = Integers.rotateRight(this.f[n4] ^ this.f[n5], 12);
        int n10 = n3;
        this.f[n10] = this.f[n10] + (this.f[n4] + this.g[this.h[n7]]);
        this.f[n6] = Integers.rotateRight(this.f[n6] ^ this.f[n3], 8);
        int n11 = n5;
        this.f[n11] = this.f[n11] + this.f[n6];
        this.f[n4] = Integers.rotateRight(this.f[n4] ^ this.f[n5], 7);
    }

    private void f() {
        for (int n2 = 0; n2 < this.h.length; n2 = (int)((byte)(n2 + 1))) {
            this.h[n2] = n2;
        }
    }

    private void g() {
        for (int n2 = 0; n2 < this.h.length; n2 = (int)((byte)(n2 + 1))) {
            this.h[n2] = a[this.h[n2]];
        }
    }

    private void h() {
        System.arraycopy(b, 0, this.d, 0, 8);
    }

    private void a(byte[] byArray) {
        Pack.littleEndianToInt(byArray, 0, this.d);
        this.m = 16;
    }

    private void i() {
        System.arraycopy(this.f, 0, this.d, 0, 8);
        this.m = 64;
    }

    private void a(int n2, boolean bl) {
        System.arraycopy(this.q == 0 ? this.d : this.e, 0, this.f, 0, 8);
        System.arraycopy(b, 0, this.f, 8, 4);
        this.f[12] = (int)this.p;
        this.f[13] = (int)(this.p >> 32);
        this.f[14] = n2;
        this.f[15] = this.m + (this.q == 0 ? 1 : 0) + (bl ? 2 : 0);
        this.q += n2;
        if (this.q >= 1024) {
            this.l();
            this.f[15] = this.f[15] | 2;
        }
        if (bl && this.i.isEmpty()) {
            this.n();
        }
    }

    private void j() {
        System.arraycopy(this.d, 0, this.f, 0, 8);
        System.arraycopy(b, 0, this.f, 8, 4);
        this.f[12] = 0;
        this.f[13] = 0;
        this.f[14] = 64;
        this.f[15] = this.m | 4;
    }

    private void k() {
        ++this.p;
        System.arraycopy(this.e, 0, this.f, 0, 8);
        System.arraycopy(b, 0, this.f, 8, 4);
        this.f[12] = (int)this.p;
        this.f[13] = (int)(this.p >> 32);
        this.f[14] = this.o;
        this.f[15] = this.n;
        this.c();
    }

    private void l() {
        ++this.p;
        this.q = 0;
    }

    private void m() {
        this.p = 0L;
        this.q = 0;
    }

    private void n() {
        this.f[15] = this.f[15] | 8;
        this.n = this.f[15];
        this.o = this.f[14];
        this.p = 0L;
        this.k = true;
        this.l = -1L;
        System.arraycopy(this.f, 0, this.e, 0, 8);
    }
}

