/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.digests;

import com.enterprisedt.bouncycastle.crypto.CryptoServiceProperties;
import com.enterprisedt.bouncycastle.crypto.CryptoServicePurpose;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.digests.EncodableDigest;
import com.enterprisedt.bouncycastle.crypto.digests.GeneralDigest;
import com.enterprisedt.bouncycastle.crypto.digests.a;
import com.enterprisedt.bouncycastle.util.Memoable;
import com.enterprisedt.bouncycastle.util.Pack;

public class SHA1Digest
extends GeneralDigest
implements EncodableDigest {
    private int a;
    private int b;
    private int c;
    private int d;
    private int e;
    private int[] f = new int[80];
    private int g;

    public SHA1Digest() {
        this(CryptoServicePurpose.ANY);
    }

    public SHA1Digest(CryptoServicePurpose purpose) {
        super(purpose);
        CryptoServicesRegistrar.checkConstraints(this.cryptoServiceProperties());
        this.reset();
    }

    public SHA1Digest(SHA1Digest t2) {
        super(t2);
        CryptoServicesRegistrar.checkConstraints(this.cryptoServiceProperties());
        this.a(t2);
    }

    public SHA1Digest(byte[] encodedState) {
        super(encodedState);
        CryptoServicesRegistrar.checkConstraints(this.cryptoServiceProperties());
        this.a = Pack.bigEndianToInt(encodedState, 16);
        this.b = Pack.bigEndianToInt(encodedState, 20);
        this.c = Pack.bigEndianToInt(encodedState, 24);
        this.d = Pack.bigEndianToInt(encodedState, 28);
        this.e = Pack.bigEndianToInt(encodedState, 32);
        this.g = Pack.bigEndianToInt(encodedState, 36);
        for (int i2 = 0; i2 != this.g; ++i2) {
            this.f[i2] = Pack.bigEndianToInt(encodedState, 40 + i2 * 4);
        }
    }

    private void a(SHA1Digest sHA1Digest) {
        this.a = sHA1Digest.a;
        this.b = sHA1Digest.b;
        this.c = sHA1Digest.c;
        this.d = sHA1Digest.d;
        this.e = sHA1Digest.e;
        System.arraycopy(sHA1Digest.f, 0, this.f, 0, sHA1Digest.f.length);
        this.g = sHA1Digest.g;
    }

    @Override
    public String getAlgorithmName() {
        return "SHA-1";
    }

    @Override
    public int getDigestSize() {
        return 20;
    }

    @Override
    protected void processWord(byte[] in, int inOff) {
        this.f[this.g] = Pack.bigEndianToInt(in, inOff);
        if (++this.g == 16) {
            this.processBlock();
        }
    }

    @Override
    protected void processLength(long bitLength) {
        if (this.g > 14) {
            this.processBlock();
        }
        this.f[14] = (int)(bitLength >>> 32);
        this.f[15] = (int)bitLength;
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        this.finish();
        Pack.intToBigEndian(this.a, out, outOff);
        Pack.intToBigEndian(this.b, out, outOff + 4);
        Pack.intToBigEndian(this.c, out, outOff + 8);
        Pack.intToBigEndian(this.d, out, outOff + 12);
        Pack.intToBigEndian(this.e, out, outOff + 16);
        this.reset();
        return 20;
    }

    @Override
    public void reset() {
        super.reset();
        this.a = 1732584193;
        this.b = -271733879;
        this.c = -1732584194;
        this.d = 271733878;
        this.e = -1009589776;
        this.g = 0;
        for (int i2 = 0; i2 != this.f.length; ++i2) {
            this.f[i2] = 0;
        }
    }

    private int a(int n2, int n3, int n4) {
        return n2 & n3 | ~n2 & n4;
    }

    private int b(int n2, int n3, int n4) {
        return n2 ^ n3 ^ n4;
    }

    private int c(int n2, int n3, int n4) {
        return n2 & n3 | n2 & n4 | n3 & n4;
    }

    @Override
    protected void processBlock() {
        int n2;
        int n3;
        int n4;
        for (n4 = 16; n4 < 80; ++n4) {
            n3 = this.f[n4 - 3] ^ this.f[n4 - 8] ^ this.f[n4 - 14] ^ this.f[n4 - 16];
            this.f[n4] = n3 << 1 | n3 >>> 31;
        }
        n4 = this.a;
        n3 = this.b;
        int n5 = this.c;
        int n6 = this.d;
        int n7 = this.e;
        int n8 = 0;
        for (n2 = 0; n2 < 4; ++n2) {
            n7 += (n4 << 5 | n4 >>> 27) + this.a(n3, n5, n6) + this.f[n8++] + 1518500249;
            n3 = n3 << 30 | n3 >>> 2;
            n6 += (n7 << 5 | n7 >>> 27) + this.a(n4, n3, n5) + this.f[n8++] + 1518500249;
            n4 = n4 << 30 | n4 >>> 2;
            n5 += (n6 << 5 | n6 >>> 27) + this.a(n7, n4, n3) + this.f[n8++] + 1518500249;
            n7 = n7 << 30 | n7 >>> 2;
            n3 += (n5 << 5 | n5 >>> 27) + this.a(n6, n7, n4) + this.f[n8++] + 1518500249;
            n6 = n6 << 30 | n6 >>> 2;
            n4 += (n3 << 5 | n3 >>> 27) + this.a(n5, n6, n7) + this.f[n8++] + 1518500249;
            n5 = n5 << 30 | n5 >>> 2;
        }
        for (n2 = 0; n2 < 4; ++n2) {
            n7 += (n4 << 5 | n4 >>> 27) + this.b(n3, n5, n6) + this.f[n8++] + 1859775393;
            n3 = n3 << 30 | n3 >>> 2;
            n6 += (n7 << 5 | n7 >>> 27) + this.b(n4, n3, n5) + this.f[n8++] + 1859775393;
            n4 = n4 << 30 | n4 >>> 2;
            n5 += (n6 << 5 | n6 >>> 27) + this.b(n7, n4, n3) + this.f[n8++] + 1859775393;
            n7 = n7 << 30 | n7 >>> 2;
            n3 += (n5 << 5 | n5 >>> 27) + this.b(n6, n7, n4) + this.f[n8++] + 1859775393;
            n6 = n6 << 30 | n6 >>> 2;
            n4 += (n3 << 5 | n3 >>> 27) + this.b(n5, n6, n7) + this.f[n8++] + 1859775393;
            n5 = n5 << 30 | n5 >>> 2;
        }
        for (n2 = 0; n2 < 4; ++n2) {
            n7 += (n4 << 5 | n4 >>> 27) + this.c(n3, n5, n6) + this.f[n8++] + -1894007588;
            n3 = n3 << 30 | n3 >>> 2;
            n6 += (n7 << 5 | n7 >>> 27) + this.c(n4, n3, n5) + this.f[n8++] + -1894007588;
            n4 = n4 << 30 | n4 >>> 2;
            n5 += (n6 << 5 | n6 >>> 27) + this.c(n7, n4, n3) + this.f[n8++] + -1894007588;
            n7 = n7 << 30 | n7 >>> 2;
            n3 += (n5 << 5 | n5 >>> 27) + this.c(n6, n7, n4) + this.f[n8++] + -1894007588;
            n6 = n6 << 30 | n6 >>> 2;
            n4 += (n3 << 5 | n3 >>> 27) + this.c(n5, n6, n7) + this.f[n8++] + -1894007588;
            n5 = n5 << 30 | n5 >>> 2;
        }
        for (n2 = 0; n2 <= 3; ++n2) {
            n7 += (n4 << 5 | n4 >>> 27) + this.b(n3, n5, n6) + this.f[n8++] + -899497514;
            n3 = n3 << 30 | n3 >>> 2;
            n6 += (n7 << 5 | n7 >>> 27) + this.b(n4, n3, n5) + this.f[n8++] + -899497514;
            n4 = n4 << 30 | n4 >>> 2;
            n5 += (n6 << 5 | n6 >>> 27) + this.b(n7, n4, n3) + this.f[n8++] + -899497514;
            n7 = n7 << 30 | n7 >>> 2;
            n3 += (n5 << 5 | n5 >>> 27) + this.b(n6, n7, n4) + this.f[n8++] + -899497514;
            n6 = n6 << 30 | n6 >>> 2;
            n4 += (n3 << 5 | n3 >>> 27) + this.b(n5, n6, n7) + this.f[n8++] + -899497514;
            n5 = n5 << 30 | n5 >>> 2;
        }
        this.a += n4;
        this.b += n3;
        this.c += n5;
        this.d += n6;
        this.e += n7;
        this.g = 0;
        for (n2 = 0; n2 < 16; ++n2) {
            this.f[n2] = 0;
        }
    }

    @Override
    public Memoable copy() {
        return new SHA1Digest(this);
    }

    @Override
    public void reset(Memoable other) {
        SHA1Digest sHA1Digest = (SHA1Digest)other;
        super.copyIn(sHA1Digest);
        this.a(sHA1Digest);
    }

    @Override
    public byte[] getEncodedState() {
        byte[] byArray = new byte[40 + this.g * 4 + 1];
        super.populateState(byArray);
        Pack.intToBigEndian(this.a, byArray, 16);
        Pack.intToBigEndian(this.b, byArray, 20);
        Pack.intToBigEndian(this.c, byArray, 24);
        Pack.intToBigEndian(this.d, byArray, 28);
        Pack.intToBigEndian(this.e, byArray, 32);
        Pack.intToBigEndian(this.g, byArray, 36);
        for (int i2 = 0; i2 != this.g; ++i2) {
            Pack.intToBigEndian(this.f[i2], byArray, 40 + i2 * 4);
        }
        byArray[byArray.length - 1] = (byte)this.purpose.ordinal();
        return byArray;
    }

    @Override
    protected CryptoServiceProperties cryptoServiceProperties() {
        return com.enterprisedt.bouncycastle.crypto.digests.a.a(this, 128, this.purpose);
    }
}

