/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.digests;

import com.enterprisedt.bouncycastle.crypto.ExtendedDigest;

public class ShortenedDigest
implements ExtendedDigest {
    private ExtendedDigest a;
    private int b;

    public ShortenedDigest(ExtendedDigest baseDigest, int length) {
        if (baseDigest == null) {
            throw new IllegalArgumentException("baseDigest must not be null");
        }
        if (length > baseDigest.getDigestSize()) {
            throw new IllegalArgumentException("baseDigest output not large enough to support length");
        }
        this.a = baseDigest;
        this.b = length;
    }

    @Override
    public String getAlgorithmName() {
        return this.a.getAlgorithmName() + "(" + this.b * 8 + ")";
    }

    @Override
    public int getDigestSize() {
        return this.b;
    }

    @Override
    public void update(byte in) {
        this.a.update(in);
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        this.a.update(in, inOff, len);
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        byte[] byArray = new byte[this.a.getDigestSize()];
        this.a.doFinal(byArray, 0);
        System.arraycopy(byArray, 0, out, outOff, this.b);
        return this.b;
    }

    @Override
    public void reset() {
        this.a.reset();
    }

    @Override
    public int getByteLength() {
        return this.a.getByteLength();
    }
}

