/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.digests;

import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.ExtendedDigest;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.engines.SparkleEngine;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Integers;
import com.enterprisedt.bouncycastle.util.Pack;

public class SparkleDigest
implements ExtendedDigest {
    private String a;
    private final int[] b;
    private final byte[] c = new byte[16];
    private final int d;
    private final int e;
    private final int f;
    private final int g;
    private int h = 0;

    public SparkleDigest(SparkleParameters sparkleParameters) {
        switch (sparkleParameters) {
            case ESCH256: {
                this.a = "ESCH-256";
                this.d = 32;
                this.e = 7;
                this.f = 11;
                this.g = 12;
                break;
            }
            case ESCH384: {
                this.a = "ESCH-384";
                this.d = 48;
                this.e = 8;
                this.f = 12;
                this.g = 16;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid definition of SCHWAEMM instance");
            }
        }
        this.b = new int[this.g];
    }

    @Override
    public String getAlgorithmName() {
        return this.a;
    }

    @Override
    public int getDigestSize() {
        return this.d;
    }

    @Override
    public int getByteLength() {
        return 16;
    }

    @Override
    public void update(byte input) {
        if (this.h == 16) {
            this.a(this.c, 0, this.e);
            this.h = 0;
        }
        this.c[this.h++] = input;
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        int n2;
        if (inOff > in.length - len) {
            throw new DataLengthException(this.a + " input buffer too short");
        }
        if (len < 1) {
            return;
        }
        int n3 = 16 - this.h;
        if (len <= n3) {
            System.arraycopy(in, inOff, this.c, this.h, len);
            this.h += len;
            return;
        }
        int n4 = 0;
        if (this.h > 0) {
            System.arraycopy(in, inOff, this.c, this.h, n3);
            this.a(this.c, 0, this.e);
            n4 += n3;
        }
        while ((n2 = len - n4) > 16) {
            this.a(in, inOff + n4, this.e);
            n4 += 16;
        }
        System.arraycopy(in, inOff + n4, this.c, 0, n2);
        this.h = n2;
    }

    @Override
    public int doFinal(byte[] output, int outOff) {
        if (outOff > output.length - this.d) {
            throw new OutputLengthException(this.a + " input buffer too short");
        }
        if (this.h < 16) {
            int n2 = (this.g >> 1) - 1;
            this.b[n2] = this.b[n2] ^ 0x1000000;
            this.c[this.h] = -128;
            while (++this.h < 16) {
                this.c[this.h] = 0;
            }
        } else {
            int n3 = (this.g >> 1) - 1;
            this.b[n3] = this.b[n3] ^ 0x2000000;
        }
        this.a(this.c, 0, this.f);
        Pack.intToLittleEndian(this.b, 0, 4, output, outOff);
        if (this.g == 16) {
            SparkleEngine.sparkle_opt16(Friend.a, this.b, this.e);
            Pack.intToLittleEndian(this.b, 0, 4, output, outOff + 16);
            SparkleEngine.sparkle_opt16(Friend.a, this.b, this.e);
            Pack.intToLittleEndian(this.b, 0, 4, output, outOff + 32);
        } else {
            SparkleEngine.sparkle_opt12(Friend.a, this.b, this.e);
            Pack.intToLittleEndian(this.b, 0, 4, output, outOff + 16);
        }
        this.reset();
        return this.d;
    }

    @Override
    public void reset() {
        Arrays.fill(this.b, 0);
        Arrays.fill(this.c, (byte)0);
        this.h = 0;
    }

    private void a(byte[] byArray, int n2, int n3) {
        int n4 = Pack.littleEndianToInt(byArray, n2);
        int n5 = Pack.littleEndianToInt(byArray, n2 + 4);
        int n6 = Pack.littleEndianToInt(byArray, n2 + 8);
        int n7 = Pack.littleEndianToInt(byArray, n2 + 12);
        int n8 = SparkleDigest.a(n4 ^ n6);
        int n9 = SparkleDigest.a(n5 ^ n7);
        this.b[0] = this.b[0] ^ (n4 ^ n9);
        this.b[1] = this.b[1] ^ (n5 ^ n8);
        this.b[2] = this.b[2] ^ (n6 ^ n9);
        this.b[3] = this.b[3] ^ (n7 ^ n8);
        this.b[4] = this.b[4] ^ n9;
        this.b[5] = this.b[5] ^ n8;
        if (this.g == 16) {
            this.b[6] = this.b[6] ^ n9;
            this.b[7] = this.b[7] ^ n8;
            SparkleEngine.sparkle_opt16(Friend.a, this.b, n3);
        } else {
            SparkleEngine.sparkle_opt12(Friend.a, this.b, n3);
        }
    }

    private static int a(int n2) {
        return Integers.rotateRight(n2, 16) ^ n2 & 0xFFFF;
    }

    public static enum SparkleParameters {
        ESCH256,
        ESCH384;

    }

    public static class Friend {
        private static final Friend a = new Friend();

        private Friend() {
        }
    }
}

