/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.encodings;

import com.enterprisedt.bouncycastle.crypto.AsymmetricBlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.crypto.util.DigestFactory;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Pack;
import java.security.SecureRandom;

public class OAEPEncoding
implements AsymmetricBlockCipher {
    private byte[] a;
    private Digest b;
    private AsymmetricBlockCipher c;
    private SecureRandom d;
    private boolean e;

    public OAEPEncoding(AsymmetricBlockCipher cipher) {
        this(cipher, DigestFactory.createSHA1(), null);
    }

    public OAEPEncoding(AsymmetricBlockCipher cipher, Digest hash) {
        this(cipher, hash, null);
    }

    public OAEPEncoding(AsymmetricBlockCipher cipher, Digest hash, byte[] encodingParams) {
        this(cipher, hash, hash, encodingParams);
    }

    public OAEPEncoding(AsymmetricBlockCipher cipher, Digest hash, Digest mgf1Hash, byte[] encodingParams) {
        this.c = cipher;
        this.b = mgf1Hash;
        this.a = new byte[hash.getDigestSize()];
        hash.reset();
        if (encodingParams != null) {
            hash.update(encodingParams, 0, encodingParams.length);
        }
        hash.doFinal(this.a, 0);
    }

    public AsymmetricBlockCipher getUnderlyingCipher() {
        return this.c;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters param) {
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)param;
            this.d = parametersWithRandom.getRandom();
        } else {
            this.d = CryptoServicesRegistrar.getSecureRandom();
        }
        this.c.init(forEncryption, param);
        this.e = forEncryption;
    }

    @Override
    public int getInputBlockSize() {
        int n2 = this.c.getInputBlockSize();
        if (this.e) {
            return n2 - 1 - 2 * this.a.length;
        }
        return n2;
    }

    @Override
    public int getOutputBlockSize() {
        int n2 = this.c.getOutputBlockSize();
        if (this.e) {
            return n2;
        }
        return n2 - 1 - 2 * this.a.length;
    }

    @Override
    public byte[] processBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        if (this.e) {
            return this.encodeBlock(in, inOff, inLen);
        }
        return this.decodeBlock(in, inOff, inLen);
    }

    public byte[] encodeBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        int n2;
        if (inLen > this.getInputBlockSize()) {
            throw new DataLengthException("input data too long");
        }
        byte[] byArray = new byte[this.getInputBlockSize() + 1 + 2 * this.a.length];
        System.arraycopy(in, inOff, byArray, byArray.length - inLen, inLen);
        byArray[byArray.length - inLen - 1] = 1;
        System.arraycopy(this.a, 0, byArray, this.a.length, this.a.length);
        byte[] byArray2 = new byte[this.a.length];
        this.d.nextBytes(byArray2);
        byte[] byArray3 = this.a(byArray2, 0, byArray2.length, byArray.length - this.a.length);
        for (n2 = this.a.length; n2 != byArray.length; ++n2) {
            int n3 = n2;
            byArray[n3] = (byte)(byArray[n3] ^ byArray3[n2 - this.a.length]);
        }
        System.arraycopy(byArray2, 0, byArray, 0, this.a.length);
        byArray3 = this.a(byArray, this.a.length, byArray.length - this.a.length, this.a.length);
        for (n2 = 0; n2 != this.a.length; ++n2) {
            int n4 = n2;
            byArray[n4] = (byte)(byArray[n4] ^ byArray3[n2]);
        }
        return this.c.processBlock(byArray, 0, byArray.length);
    }

    public byte[] decodeBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        int n2;
        byte[] byArray = this.c.processBlock(in, inOff, inLen);
        byte[] byArray2 = new byte[this.c.getOutputBlockSize()];
        int n3 = byArray2.length - (2 * this.a.length + 1) >> 31;
        if (byArray.length <= byArray2.length) {
            System.arraycopy(byArray, 0, byArray2, byArray2.length - byArray.length, byArray.length);
        } else {
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            n3 |= 1;
        }
        byte[] byArray3 = this.a(byArray2, this.a.length, byArray2.length - this.a.length, this.a.length);
        for (n2 = 0; n2 != this.a.length; ++n2) {
            int n4 = n2;
            byArray2[n4] = (byte)(byArray2[n4] ^ byArray3[n2]);
        }
        byArray3 = this.a(byArray2, 0, this.a.length, byArray2.length - this.a.length);
        for (n2 = this.a.length; n2 != byArray2.length; ++n2) {
            int n5 = n2;
            byArray2[n5] = (byte)(byArray2[n5] ^ byArray3[n2 - this.a.length]);
        }
        for (n2 = 0; n2 != this.a.length; ++n2) {
            n3 |= this.a[n2] ^ byArray2[this.a.length + n2];
        }
        n2 = -1;
        for (int i2 = 2 * this.a.length; i2 != byArray2.length; ++i2) {
            int n6 = byArray2[i2] & 0xFF;
            int n7 = (-n6 & n2) >> 31;
            n2 += i2 & n7;
        }
        n3 |= n2 >> 31;
        if ((n3 |= byArray2[++n2] ^ 1) != 0) {
            Arrays.fill(byArray2, (byte)0);
            throw new InvalidCipherTextException("data wrong");
        }
        byte[] byArray4 = new byte[byArray2.length - ++n2];
        System.arraycopy(byArray2, n2, byArray4, 0, byArray4.length);
        Arrays.fill(byArray2, (byte)0);
        return byArray4;
    }

    private byte[] a(byte[] byArray, int n2, int n3, int n4) {
        int n5;
        byte[] byArray2 = new byte[n4];
        byte[] byArray3 = new byte[this.b.getDigestSize()];
        byte[] byArray4 = new byte[4];
        this.b.reset();
        for (n5 = 0; n5 < n4 / byArray3.length; ++n5) {
            Pack.intToBigEndian(n5, byArray4, 0);
            this.b.update(byArray, n2, n3);
            this.b.update(byArray4, 0, byArray4.length);
            this.b.doFinal(byArray3, 0);
            System.arraycopy(byArray3, 0, byArray2, n5 * byArray3.length, byArray3.length);
        }
        if (n5 * byArray3.length < n4) {
            Pack.intToBigEndian(n5, byArray4, 0);
            this.b.update(byArray, n2, n3);
            this.b.update(byArray4, 0, byArray4.length);
            this.b.doFinal(byArray3, 0);
            System.arraycopy(byArray3, 0, byArray2, n5 * byArray3.length, byArray2.length - n5 * byArray3.length);
        }
        return byArray2;
    }
}

