/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.constraints.ConstraintUtils;
import com.enterprisedt.bouncycastle.crypto.constraints.DefaultServiceProperties;
import com.enterprisedt.bouncycastle.crypto.engines.CramerShoupCiphertext;
import com.enterprisedt.bouncycastle.crypto.engines.c;
import com.enterprisedt.bouncycastle.crypto.params.CramerShoupKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.CramerShoupPrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.CramerShoupPublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import com.enterprisedt.bouncycastle.util.Strings;
import java.math.BigInteger;
import java.security.SecureRandom;

public class CramerShoupCoreEngine {
    private static final BigInteger a = BigInteger.valueOf(1L);
    private CramerShoupKeyParameters b;
    private SecureRandom c;
    private boolean d;
    private byte[] e = null;

    public void init(boolean forEncryption, CipherParameters param, String label) {
        this.init(forEncryption, param);
        this.e = Strings.toUTF8ByteArray(label);
    }

    public void init(boolean forEncryption, CipherParameters param) {
        SecureRandom secureRandom = null;
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)param;
            this.b = (CramerShoupKeyParameters)parametersWithRandom.getParameters();
            secureRandom = parametersWithRandom.getRandom();
        } else {
            this.b = (CramerShoupKeyParameters)param;
        }
        this.c = this.initSecureRandom(forEncryption, secureRandom);
        this.d = forEncryption;
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("CramerShoup", ConstraintUtils.bitsOfSecurityFor(this.b.getParameters().getP()), this.b, com.enterprisedt.bouncycastle.crypto.engines.c.a(forEncryption)));
    }

    public int getInputBlockSize() {
        int n2 = this.b.getParameters().getP().bitLength();
        if (this.d) {
            return (n2 + 7) / 8 - 1;
        }
        return (n2 + 7) / 8;
    }

    public int getOutputBlockSize() {
        int n2 = this.b.getParameters().getP().bitLength();
        if (this.d) {
            return (n2 + 7) / 8;
        }
        return (n2 + 7) / 8 - 1;
    }

    public BigInteger convertInput(byte[] in, int inOff, int inLen) {
        byte[] byArray;
        if (inLen > this.getInputBlockSize() + 1) {
            throw new DataLengthException("input too large for Cramer Shoup cipher.");
        }
        if (inLen == this.getInputBlockSize() + 1 && this.d) {
            throw new DataLengthException("input too large for Cramer Shoup cipher.");
        }
        if (inOff != 0 || inLen != in.length) {
            byArray = new byte[inLen];
            System.arraycopy(in, inOff, byArray, 0, inLen);
        } else {
            byArray = in;
        }
        BigInteger bigInteger = new BigInteger(1, byArray);
        if (bigInteger.compareTo(this.b.getParameters().getP()) >= 0) {
            throw new DataLengthException("input too large for Cramer Shoup cipher.");
        }
        return bigInteger;
    }

    public byte[] convertOutput(BigInteger result) {
        byte[] byArray = result.toByteArray();
        if (!this.d) {
            if (byArray[0] == 0 && byArray.length > this.getOutputBlockSize()) {
                byte[] byArray2 = new byte[byArray.length - 1];
                System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
                return byArray2;
            }
            if (byArray.length < this.getOutputBlockSize()) {
                byte[] byArray3 = new byte[this.getOutputBlockSize()];
                System.arraycopy(byArray, 0, byArray3, byArray3.length - byArray.length, byArray.length);
                return byArray3;
            }
        } else if (byArray[0] == 0) {
            byte[] byArray4 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray4, 0, byArray4.length);
            return byArray4;
        }
        return byArray;
    }

    public CramerShoupCiphertext encryptBlock(BigInteger input) {
        CramerShoupCiphertext cramerShoupCiphertext = null;
        if (!this.b.isPrivate() && this.d && this.b instanceof CramerShoupPublicKeyParameters) {
            byte[] byArray;
            CramerShoupPublicKeyParameters cramerShoupPublicKeyParameters = (CramerShoupPublicKeyParameters)this.b;
            BigInteger bigInteger = cramerShoupPublicKeyParameters.getParameters().getP();
            BigInteger bigInteger2 = cramerShoupPublicKeyParameters.getParameters().getG1();
            BigInteger bigInteger3 = cramerShoupPublicKeyParameters.getParameters().getG2();
            BigInteger bigInteger4 = cramerShoupPublicKeyParameters.getH();
            if (!this.a(input, bigInteger)) {
                return cramerShoupCiphertext;
            }
            BigInteger bigInteger5 = this.a(bigInteger, this.c);
            BigInteger bigInteger6 = bigInteger2.modPow(bigInteger5, bigInteger);
            BigInteger bigInteger7 = bigInteger3.modPow(bigInteger5, bigInteger);
            BigInteger bigInteger8 = bigInteger4.modPow(bigInteger5, bigInteger).multiply(input).mod(bigInteger);
            Digest digest = cramerShoupPublicKeyParameters.getParameters().getH();
            byte[] byArray2 = bigInteger6.toByteArray();
            digest.update(byArray2, 0, byArray2.length);
            byte[] byArray3 = bigInteger7.toByteArray();
            digest.update(byArray3, 0, byArray3.length);
            byte[] byArray4 = bigInteger8.toByteArray();
            digest.update(byArray4, 0, byArray4.length);
            if (this.e != null) {
                byArray = this.e;
                digest.update(byArray, 0, byArray.length);
            }
            byArray = new byte[digest.getDigestSize()];
            digest.doFinal(byArray, 0);
            BigInteger bigInteger9 = new BigInteger(1, byArray);
            BigInteger bigInteger10 = cramerShoupPublicKeyParameters.getC().modPow(bigInteger5, bigInteger).multiply(cramerShoupPublicKeyParameters.getD().modPow(bigInteger5.multiply(bigInteger9), bigInteger)).mod(bigInteger);
            cramerShoupCiphertext = new CramerShoupCiphertext(bigInteger6, bigInteger7, bigInteger8, bigInteger10);
        }
        return cramerShoupCiphertext;
    }

    public BigInteger decryptBlock(CramerShoupCiphertext input) throws CramerShoupCiphertextException {
        BigInteger bigInteger = null;
        if (this.b.isPrivate() && !this.d && this.b instanceof CramerShoupPrivateKeyParameters) {
            byte[] byArray;
            CramerShoupPrivateKeyParameters cramerShoupPrivateKeyParameters = (CramerShoupPrivateKeyParameters)this.b;
            BigInteger bigInteger2 = cramerShoupPrivateKeyParameters.getParameters().getP();
            Digest digest = cramerShoupPrivateKeyParameters.getParameters().getH();
            byte[] byArray2 = input.getU1().toByteArray();
            digest.update(byArray2, 0, byArray2.length);
            byte[] byArray3 = input.getU2().toByteArray();
            digest.update(byArray3, 0, byArray3.length);
            byte[] byArray4 = input.getE().toByteArray();
            digest.update(byArray4, 0, byArray4.length);
            if (this.e != null) {
                byArray = this.e;
                digest.update(byArray, 0, byArray.length);
            }
            byArray = new byte[digest.getDigestSize()];
            digest.doFinal(byArray, 0);
            BigInteger bigInteger3 = new BigInteger(1, byArray);
            BigInteger bigInteger4 = input.a.modPow(cramerShoupPrivateKeyParameters.getX1().add(cramerShoupPrivateKeyParameters.getY1().multiply(bigInteger3)), bigInteger2).multiply(input.b.modPow(cramerShoupPrivateKeyParameters.getX2().add(cramerShoupPrivateKeyParameters.getY2().multiply(bigInteger3)), bigInteger2)).mod(bigInteger2);
            if (input.d.equals(bigInteger4)) {
                bigInteger = input.c.multiply(input.a.modPow(cramerShoupPrivateKeyParameters.getZ(), bigInteger2).modInverse(bigInteger2)).mod(bigInteger2);
            } else {
                throw new CramerShoupCiphertextException("Sorry, that ciphertext is not correct");
            }
        }
        return bigInteger;
    }

    private BigInteger a(BigInteger bigInteger, SecureRandom secureRandom) {
        return BigIntegers.createRandomInRange(a, bigInteger.subtract(a), secureRandom);
    }

    private boolean a(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.compareTo(bigInteger2) < 0;
    }

    protected SecureRandom initSecureRandom(boolean needed, SecureRandom provided) {
        return needed ? CryptoServicesRegistrar.getSecureRandom(provided) : null;
    }

    public static class CramerShoupCiphertextException
    extends Exception {
        private static final long serialVersionUID = -6360977166495345076L;

        public CramerShoupCiphertextException(String msg) {
            super(msg);
        }
    }
}

