/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.StreamCipher;
import com.enterprisedt.bouncycastle.crypto.constraints.DefaultServiceProperties;
import com.enterprisedt.bouncycastle.crypto.engines.c;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;

public class HC128Engine
implements StreamCipher {
    private int[] a = new int[512];
    private int[] b = new int[512];
    private int c = 0;
    private byte[] d;
    private byte[] e;
    private boolean f;
    private byte[] g = new byte[4];
    private int h = 0;

    private static int a(int n2) {
        return HC128Engine.b(n2, 7) ^ HC128Engine.b(n2, 18) ^ n2 >>> 3;
    }

    private static int b(int n2) {
        return HC128Engine.b(n2, 17) ^ HC128Engine.b(n2, 19) ^ n2 >>> 10;
    }

    private int a(int n2, int n3, int n4) {
        return (HC128Engine.b(n2, 10) ^ HC128Engine.b(n4, 23)) + HC128Engine.b(n3, 8);
    }

    private int b(int n2, int n3, int n4) {
        return (HC128Engine.a(n2, 10) ^ HC128Engine.a(n4, 23)) + HC128Engine.a(n3, 8);
    }

    private static int a(int n2, int n3) {
        return n2 << n3 | n2 >>> -n3;
    }

    private static int b(int n2, int n3) {
        return n2 >>> n3 | n2 << -n3;
    }

    private int c(int n2) {
        return this.b[n2 & 0xFF] + this.b[(n2 >> 16 & 0xFF) + 256];
    }

    private int d(int n2) {
        return this.a[n2 & 0xFF] + this.a[(n2 >> 16 & 0xFF) + 256];
    }

    private static int e(int n2) {
        return n2 & 0x3FF;
    }

    private static int f(int n2) {
        return n2 & 0x1FF;
    }

    private static int c(int n2, int n3) {
        return HC128Engine.f(n2 - n3);
    }

    private int a() {
        int n2;
        int n3 = HC128Engine.f(this.c);
        if (this.c < 512) {
            int n4 = n3;
            this.a[n4] = this.a[n4] + this.a(this.a[HC128Engine.c(n3, 3)], this.a[HC128Engine.c(n3, 10)], this.a[HC128Engine.c(n3, 511)]);
            n2 = this.c(this.a[HC128Engine.c(n3, 12)]) ^ this.a[n3];
        } else {
            int n5 = n3;
            this.b[n5] = this.b[n5] + this.b(this.b[HC128Engine.c(n3, 3)], this.b[HC128Engine.c(n3, 10)], this.b[HC128Engine.c(n3, 511)]);
            n2 = this.d(this.b[HC128Engine.c(n3, 12)]) ^ this.b[n3];
        }
        this.c = HC128Engine.e(this.c + 1);
        return n2;
    }

    private void b() {
        int n2;
        if (this.d.length != 16) {
            throw new IllegalArgumentException("The key must be 128 bits long");
        }
        if (this.e.length != 16) {
            throw new IllegalArgumentException("The IV must be 128 bits long");
        }
        this.h = 0;
        this.c = 0;
        int[] nArray = new int[1280];
        for (n2 = 0; n2 < 16; ++n2) {
            int n3 = n2 >> 2;
            nArray[n3] = nArray[n3] | (this.d[n2] & 0xFF) << 8 * (n2 & 3);
        }
        System.arraycopy(nArray, 0, nArray, 4, 4);
        for (n2 = 0; n2 < this.e.length && n2 < 16; ++n2) {
            int n4 = (n2 >> 2) + 8;
            nArray[n4] = nArray[n4] | (this.e[n2] & 0xFF) << 8 * (n2 & 3);
        }
        System.arraycopy(nArray, 8, nArray, 12, 4);
        for (n2 = 16; n2 < 1280; ++n2) {
            nArray[n2] = HC128Engine.b(nArray[n2 - 2]) + nArray[n2 - 7] + HC128Engine.a(nArray[n2 - 15]) + nArray[n2 - 16] + n2;
        }
        System.arraycopy(nArray, 256, this.a, 0, 512);
        System.arraycopy(nArray, 768, this.b, 0, 512);
        for (n2 = 0; n2 < 512; ++n2) {
            this.a[n2] = this.a();
        }
        for (n2 = 0; n2 < 512; ++n2) {
            this.b[n2] = this.a();
        }
        this.c = 0;
    }

    @Override
    public String getAlgorithmName() {
        return "HC-128";
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        if (!(params instanceof ParametersWithIV)) {
            throw new IllegalArgumentException("no IV passed");
        }
        this.e = ((ParametersWithIV)params).getIV();
        CipherParameters cipherParameters = ((ParametersWithIV)params).getParameters();
        if (!(cipherParameters instanceof KeyParameter)) {
            throw new IllegalArgumentException("Invalid parameter passed to HC128 init - " + params.getClass().getName());
        }
        this.d = ((KeyParameter)cipherParameters).getKey();
        this.b();
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.getAlgorithmName(), 128, params, com.enterprisedt.bouncycastle.crypto.engines.c.a(forEncryption)));
        this.f = true;
    }

    private byte c() {
        int n2;
        if (this.h == 0) {
            n2 = this.a();
            this.g[0] = (byte)(n2 & 0xFF);
            this.g[1] = (byte)((n2 >>= 8) & 0xFF);
            this.g[2] = (byte)((n2 >>= 8) & 0xFF);
            this.g[3] = (byte)((n2 >>= 8) & 0xFF);
        }
        n2 = this.g[this.h];
        this.h = this.h + 1 & 3;
        return (byte)n2;
    }

    @Override
    public int processBytes(byte[] in, int inOff, int len, byte[] out, int outOff) throws DataLengthException {
        if (!this.f) {
            throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
        }
        if (inOff + len > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + len > out.length) {
            throw new OutputLengthException("output buffer too short");
        }
        for (int i2 = 0; i2 < len; ++i2) {
            out[outOff + i2] = (byte)(in[inOff + i2] ^ this.c());
        }
        return len;
    }

    @Override
    public void reset() {
        this.b();
    }

    @Override
    public byte returnByte(byte in) {
        return (byte)(in ^ this.c());
    }
}

