/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.Wrapper;
import com.enterprisedt.bouncycastle.crypto.engines.RFC3394WrapEngine;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Pack;

public class RFC5649WrapEngine
implements Wrapper {
    private static final byte[] a = new byte[]{-90, 89, 89, -90};
    private final BlockCipher b;
    private final byte[] c = new byte[4];
    private KeyParameter d = null;
    private boolean e = true;

    public RFC5649WrapEngine(BlockCipher engine) {
        this.b = engine;
    }

    @Override
    public void init(boolean forWrapping, CipherParameters param) {
        this.e = forWrapping;
        if (param instanceof ParametersWithRandom) {
            param = ((ParametersWithRandom)param).getParameters();
        }
        if (param instanceof KeyParameter) {
            this.d = (KeyParameter)param;
            System.arraycopy(a, 0, this.c, 0, 4);
        } else if (param instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)param;
            byte[] byArray = parametersWithIV.getIV();
            if (byArray.length != 4) {
                throw new IllegalArgumentException("IV length not equal to 4");
            }
            this.d = (KeyParameter)parametersWithIV.getParameters();
            System.arraycopy(byArray, 0, this.c, 0, 4);
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.b.getAlgorithmName();
    }

    private byte[] a(byte[] byArray) {
        int n2 = byArray.length;
        int n3 = (8 - n2 % 8) % 8;
        byte[] byArray2 = new byte[n2 + n3];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        if (n3 != 0) {
            byte[] byArray3 = new byte[n3];
            System.arraycopy(byArray3, 0, byArray2, n2, n3);
        }
        return byArray2;
    }

    @Override
    public byte[] wrap(byte[] in, int inOff, int inLen) {
        if (!this.e) {
            throw new IllegalStateException("not set for wrapping");
        }
        byte[] byArray = new byte[8];
        System.arraycopy(this.c, 0, byArray, 0, 4);
        Pack.intToBigEndian(inLen, byArray, 4);
        byte[] byArray2 = new byte[inLen];
        System.arraycopy(in, inOff, byArray2, 0, inLen);
        byte[] byArray3 = this.a(byArray2);
        if (byArray3.length == 8) {
            byte[] byArray4 = new byte[byArray3.length + byArray.length];
            System.arraycopy(byArray, 0, byArray4, 0, byArray.length);
            System.arraycopy(byArray3, 0, byArray4, byArray.length, byArray3.length);
            this.b.init(true, this.d);
            int n2 = this.b.getBlockSize();
            for (int i2 = 0; i2 < byArray4.length; i2 += n2) {
                this.b.processBlock(byArray4, i2, byArray4, i2);
            }
            return byArray4;
        }
        RFC3394WrapEngine rFC3394WrapEngine = new RFC3394WrapEngine(this.b);
        ParametersWithIV parametersWithIV = new ParametersWithIV(this.d, byArray);
        rFC3394WrapEngine.init(true, parametersWithIV);
        return rFC3394WrapEngine.wrap(byArray3, 0, byArray3.length);
    }

    @Override
    public byte[] unwrap(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        int n2;
        byte[] byArray;
        int n3;
        if (this.e) {
            throw new IllegalStateException("not set for unwrapping");
        }
        int n4 = inLen / 8;
        if (n4 * 8 != inLen) {
            throw new InvalidCipherTextException("unwrap data must be a multiple of 8 bytes");
        }
        if (n4 <= 1) {
            throw new InvalidCipherTextException("unwrap data must be at least 16 bytes");
        }
        byte[] byArray2 = new byte[inLen];
        System.arraycopy(in, inOff, byArray2, 0, inLen);
        byte[] byArray3 = new byte[inLen];
        byte[] byArray4 = new byte[8];
        if (n4 == 2) {
            this.b.init(false, this.d);
            n3 = this.b.getBlockSize();
            for (int i2 = 0; i2 < byArray2.length; i2 += n3) {
                this.b.processBlock(byArray2, i2, byArray3, i2);
            }
            System.arraycopy(byArray3, 0, byArray4, 0, byArray4.length);
            byArray = new byte[byArray3.length - byArray4.length];
            System.arraycopy(byArray3, byArray4.length, byArray, 0, byArray.length);
        } else {
            byArray = byArray3 = this.a(in, inOff, inLen, byArray4);
        }
        byte[] byArray5 = new byte[4];
        System.arraycopy(byArray4, 0, byArray5, 0, 4);
        n3 = Pack.bigEndianToInt(byArray4, 4);
        boolean bl = Arrays.constantTimeAreEqual(byArray5, this.c);
        int n5 = byArray.length;
        int n6 = n5 - 8;
        if (n3 <= n6) {
            bl = false;
        }
        if (n3 > n5) {
            bl = false;
        }
        if ((n2 = n5 - n3) >= 8 || n2 < 0) {
            bl = false;
            n2 = 4;
        }
        byte[] byArray6 = new byte[n2];
        byte[] byArray7 = new byte[n2];
        System.arraycopy(byArray, byArray.length - n2, byArray7, 0, n2);
        if (!Arrays.constantTimeAreEqual(byArray7, byArray6)) {
            bl = false;
        }
        if (!bl) {
            throw new InvalidCipherTextException("checksum failed");
        }
        byte[] byArray8 = new byte[n3];
        System.arraycopy(byArray, 0, byArray8, 0, byArray8.length);
        return byArray8;
    }

    private byte[] a(byte[] byArray, int n2, int n3, byte[] byArray2) {
        byte[] byArray3 = new byte[n3 - 8];
        byte[] byArray4 = new byte[16];
        System.arraycopy(byArray, n2, byArray4, 0, 8);
        System.arraycopy(byArray, n2 + 8, byArray3, 0, n3 - 8);
        this.b.init(false, this.d);
        int n4 = n3 / 8;
        --n4;
        for (int i2 = 5; i2 >= 0; --i2) {
            for (int i3 = n4; i3 >= 1; --i3) {
                System.arraycopy(byArray3, 8 * (i3 - 1), byArray4, 8, 8);
                int n5 = n4 * i2 + i3;
                int n6 = 1;
                while (n5 != 0) {
                    int n7 = 8 - n6;
                    byArray4[n7] = (byte)(byArray4[n7] ^ (byte)n5);
                    n5 >>>= 8;
                    ++n6;
                }
                this.b.processBlock(byArray4, 0, byArray4, 0);
                System.arraycopy(byArray4, 8, byArray3, 8 * (i3 - 1), 8);
            }
        }
        System.arraycopy(byArray4, 0, byArray2, 0, 8);
        return byArray3;
    }
}

