/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.engines.Zuc128CoreEngine;
import com.enterprisedt.bouncycastle.util.Memoable;

public class Zuc256CoreEngine
extends Zuc128CoreEngine {
    private static final byte[] a = new byte[]{34, 47, 36, 42, 109, 64, 64, 64, 64, 64, 64, 64, 64, 82, 16, 48};
    private static final byte[] b = new byte[]{34, 47, 37, 42, 109, 64, 64, 64, 64, 64, 64, 64, 64, 82, 16, 48};
    private static final byte[] c = new byte[]{35, 47, 36, 42, 109, 64, 64, 64, 64, 64, 64, 64, 64, 82, 16, 48};
    private static final byte[] d = new byte[]{35, 47, 37, 42, 109, 64, 64, 64, 64, 64, 64, 64, 64, 82, 16, 48};
    private byte[] e;

    protected Zuc256CoreEngine() {
        this.e = a;
    }

    protected Zuc256CoreEngine(int pLength) {
        switch (pLength) {
            case 32: {
                this.e = b;
                break;
            }
            case 64: {
                this.e = c;
                break;
            }
            case 128: {
                this.e = d;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported length: " + pLength);
            }
        }
    }

    protected Zuc256CoreEngine(Zuc256CoreEngine pSource) {
        super(pSource);
    }

    @Override
    protected int getMaxIterations() {
        return 625;
    }

    @Override
    public String getAlgorithmName() {
        return "Zuc-256";
    }

    private static int a(byte by, byte by2, byte by3, byte by4) {
        return (by & 0xFF) << 23 | (by2 & 0xFF) << 16 | (by3 & 0xFF) << 8 | by4 & 0xFF;
    }

    @Override
    protected void setKeyAndIV(int[] pLFSR, byte[] k2, byte[] iv) {
        if (k2 == null || k2.length != 32) {
            throw new IllegalArgumentException("A key of 32 bytes is needed");
        }
        if (iv == null || iv.length != 25) {
            throw new IllegalArgumentException("An IV of 25 bytes is needed");
        }
        pLFSR[0] = Zuc256CoreEngine.a(k2[0], this.e[0], k2[21], k2[16]);
        pLFSR[1] = Zuc256CoreEngine.a(k2[1], this.e[1], k2[22], k2[17]);
        pLFSR[2] = Zuc256CoreEngine.a(k2[2], this.e[2], k2[23], k2[18]);
        pLFSR[3] = Zuc256CoreEngine.a(k2[3], this.e[3], k2[24], k2[19]);
        pLFSR[4] = Zuc256CoreEngine.a(k2[4], this.e[4], k2[25], k2[20]);
        pLFSR[5] = Zuc256CoreEngine.a(iv[0], (byte)(this.e[5] | iv[17] & 0x3F), k2[5], k2[26]);
        pLFSR[6] = Zuc256CoreEngine.a(iv[1], (byte)(this.e[6] | iv[18] & 0x3F), k2[6], k2[27]);
        pLFSR[7] = Zuc256CoreEngine.a(iv[10], (byte)(this.e[7] | iv[19] & 0x3F), k2[7], iv[2]);
        pLFSR[8] = Zuc256CoreEngine.a(k2[8], (byte)(this.e[8] | iv[20] & 0x3F), iv[3], iv[11]);
        pLFSR[9] = Zuc256CoreEngine.a(k2[9], (byte)(this.e[9] | iv[21] & 0x3F), iv[12], iv[4]);
        pLFSR[10] = Zuc256CoreEngine.a(iv[5], (byte)(this.e[10] | iv[22] & 0x3F), k2[10], k2[28]);
        pLFSR[11] = Zuc256CoreEngine.a(k2[11], (byte)(this.e[11] | iv[23] & 0x3F), iv[6], iv[13]);
        pLFSR[12] = Zuc256CoreEngine.a(k2[12], (byte)(this.e[12] | iv[24] & 0x3F), iv[7], iv[14]);
        pLFSR[13] = Zuc256CoreEngine.a(k2[13], this.e[13], iv[15], iv[8]);
        pLFSR[14] = Zuc256CoreEngine.a(k2[14], (byte)(this.e[14] | k2[31] >>> 4 & 0xF), iv[16], iv[9]);
        pLFSR[15] = Zuc256CoreEngine.a(k2[15], (byte)(this.e[15] | k2[31] & 0xF), k2[30], k2[29]);
    }

    @Override
    public Memoable copy() {
        return new Zuc256CoreEngine(this);
    }

    @Override
    public void reset(Memoable pState) {
        Zuc256CoreEngine zuc256CoreEngine = (Zuc256CoreEngine)pState;
        super.reset(pState);
        this.e = zuc256CoreEngine.e;
    }
}

