/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.examples;

import com.enterprisedt.bouncycastle.crypto.CryptoException;
import com.enterprisedt.bouncycastle.crypto.KeyGenerationParameters;
import com.enterprisedt.bouncycastle.crypto.engines.DESedeEngine;
import com.enterprisedt.bouncycastle.crypto.generators.DESedeKeyGenerator;
import com.enterprisedt.bouncycastle.crypto.modes.CBCBlockCipher;
import com.enterprisedt.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.util.encoders.Hex;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.SecureRandom;

public class DESExample {
    private boolean a = true;
    private PaddedBufferedBlockCipher b = null;
    private BufferedInputStream c = null;
    private BufferedOutputStream d = null;
    private byte[] e = null;

    public static void main(String[] args) {
        DESExample dESExample;
        boolean bl = true;
        String string = null;
        String string2 = null;
        String string3 = null;
        if (args.length < 2) {
            dESExample = new DESExample();
            System.err.println("Usage: java " + dESExample.getClass().getName() + " infile outfile [keyfile]");
            System.exit(1);
        }
        string3 = "deskey.dat";
        string = args[0];
        string2 = args[1];
        if (args.length > 2) {
            bl = false;
            string3 = args[2];
        }
        dESExample = new DESExample(string, string2, string3, bl);
        dESExample.a();
    }

    public DESExample() {
    }

    public DESExample(String infile, String outfile, String keyfile, boolean encrypt) {
        Object object;
        this.a = encrypt;
        try {
            this.c = new BufferedInputStream(new FileInputStream(infile));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Input file not found [" + infile + "]");
            System.exit(1);
        }
        try {
            this.d = new BufferedOutputStream(new FileOutputStream(outfile));
        }
        catch (IOException iOException) {
            System.err.println("Output file not created [" + outfile + "]");
            System.exit(1);
        }
        if (encrypt) {
            try {
                object = null;
                try {
                    object = new SecureRandom();
                    ((SecureRandom)object).setSeed("www.bouncycastle.org".getBytes());
                }
                catch (Exception exception) {
                    System.err.println("Hmmm, no SHA1PRNG, you need the Sun implementation");
                    System.exit(1);
                }
                KeyGenerationParameters keyGenerationParameters = new KeyGenerationParameters((SecureRandom)object, 192);
                DESedeKeyGenerator dESedeKeyGenerator = new DESedeKeyGenerator();
                dESedeKeyGenerator.init(keyGenerationParameters);
                this.e = dESedeKeyGenerator.generateKey();
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(keyfile));
                byte[] byArray = Hex.encode(this.e);
                bufferedOutputStream.write(byArray, 0, byArray.length);
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("Could not decryption create key file [" + keyfile + "]");
                System.exit(1);
            }
        } else {
            try {
                object = new BufferedInputStream(new FileInputStream(keyfile));
                int n2 = ((BufferedInputStream)object).available();
                byte[] byArray = new byte[n2];
                ((BufferedInputStream)object).read(byArray, 0, n2);
                this.e = Hex.decode(byArray);
            }
            catch (IOException iOException) {
                System.err.println("Decryption key file not found, or not valid [" + keyfile + "]");
                System.exit(1);
            }
        }
    }

    private void a() {
        this.b = new PaddedBufferedBlockCipher(new CBCBlockCipher(new DESedeEngine()));
        if (this.a) {
            this.a(this.e);
        } else {
            this.b(this.e);
        }
        try {
            this.c.close();
            this.d.flush();
            this.d.close();
        }
        catch (IOException iOException) {
            System.err.println("exception closing resources: " + iOException.getMessage());
        }
    }

    private void a(byte[] byArray) {
        this.b.init(true, new KeyParameter(byArray));
        int n2 = 47;
        int n3 = this.b.getOutputSize(n2);
        byte[] byArray2 = new byte[n2];
        byte[] byArray3 = new byte[n3];
        try {
            int n4;
            int n5;
            byte[] byArray4 = null;
            while ((n5 = this.c.read(byArray2, 0, n2)) > 0) {
                n4 = this.b.processBytes(byArray2, 0, n5, byArray3, 0);
                if (n4 <= 0) continue;
                byArray4 = Hex.encode(byArray3, 0, n4);
                this.d.write(byArray4, 0, byArray4.length);
                this.d.write(10);
            }
            try {
                n4 = this.b.doFinal(byArray3, 0);
                if (n4 > 0) {
                    byArray4 = Hex.encode(byArray3, 0, n4);
                    this.d.write(byArray4, 0, byArray4.length);
                    this.d.write(10);
                }
            }
            catch (CryptoException cryptoException) {}
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void b(byte[] byArray) {
        this.b.init(false, new KeyParameter(byArray));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.c));
        try {
            int n2;
            byte[] byArray2 = null;
            byte[] byArray3 = null;
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                byArray2 = Hex.decode(string);
                n2 = this.b.processBytes(byArray2, 0, byArray2.length, byArray3 = new byte[this.b.getOutputSize(byArray2.length)], 0);
                if (n2 <= 0) continue;
                this.d.write(byArray3, 0, n2);
            }
            try {
                n2 = this.b.doFinal(byArray3, 0);
                if (n2 > 0) {
                    this.d.write(byArray3, 0, n2);
                }
            }
            catch (CryptoException cryptoException) {}
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

