/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.fpe;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.engines.AESEngine;
import com.enterprisedt.bouncycastle.crypto.fpe.FPEEngine;
import com.enterprisedt.bouncycastle.crypto.fpe.a;
import com.enterprisedt.bouncycastle.crypto.params.FPEParameters;
import com.enterprisedt.bouncycastle.util.Properties;

public class FPEFF3_1Engine
extends FPEEngine {
    public FPEFF3_1Engine() {
        this(AESEngine.newInstance());
    }

    public FPEFF3_1Engine(BlockCipher baseCipher) {
        super(baseCipher);
        if (baseCipher.getBlockSize() != 16) {
            throw new IllegalArgumentException("base cipher needs to be 128 bits");
        }
        if (Properties.isOverrideSet("com.enterprisedt.bouncycastle.fpe.disable")) {
            throw new UnsupportedOperationException("FPE disabled");
        }
    }

    @Override
    public void init(boolean forEncryption, CipherParameters parameters) {
        this.forEncryption = forEncryption;
        this.fpeParameters = (FPEParameters)parameters;
        this.baseCipher.init(!this.fpeParameters.isUsingInverseFunction(), this.fpeParameters.getKey().reverse());
        if (this.fpeParameters.getTweak().length != 7) {
            throw new IllegalArgumentException("tweak should be 56 bits");
        }
    }

    @Override
    public String getAlgorithmName() {
        return "FF3-1";
    }

    @Override
    protected int encryptBlock(byte[] inBuf, int inOff, int length, byte[] outBuf, int outOff) {
        byte[] byArray = this.fpeParameters.getRadix() > 256 ? FPEFF3_1Engine.toByteArray(a.e(this.baseCipher, this.fpeParameters.getRadixConverter(), this.fpeParameters.getTweak(), FPEFF3_1Engine.toShortArray(inBuf), inOff, length / 2)) : a.e(this.baseCipher, this.fpeParameters.getRadixConverter(), this.fpeParameters.getTweak(), inBuf, inOff, length);
        System.arraycopy(byArray, 0, outBuf, outOff, length);
        return length;
    }

    @Override
    protected int decryptBlock(byte[] inBuf, int inOff, int length, byte[] outBuf, int outOff) {
        byte[] byArray = this.fpeParameters.getRadix() > 256 ? FPEFF3_1Engine.toByteArray(a.b(this.baseCipher, this.fpeParameters.getRadixConverter(), this.fpeParameters.getTweak(), FPEFF3_1Engine.toShortArray(inBuf), inOff, length / 2)) : a.b(this.baseCipher, this.fpeParameters.getRadixConverter(), this.fpeParameters.getTweak(), inBuf, inOff, length);
        System.arraycopy(byArray, 0, outBuf, outOff, length);
        return length;
    }
}

