/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.generators;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.crypto.params.RSAKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class RSABlindingFactorGenerator {
    private static BigInteger a = BigInteger.valueOf(0L);
    private static BigInteger b = BigInteger.valueOf(1L);
    private RSAKeyParameters c;
    private SecureRandom d;

    public void init(CipherParameters param) {
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)param;
            this.c = (RSAKeyParameters)parametersWithRandom.getParameters();
            this.d = parametersWithRandom.getRandom();
        } else {
            this.c = (RSAKeyParameters)param;
            this.d = CryptoServicesRegistrar.getSecureRandom();
        }
        if (this.c instanceof RSAPrivateCrtKeyParameters) {
            throw new IllegalArgumentException("generator requires RSA public key");
        }
    }

    public BigInteger generateBlindingFactor() {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        if (this.c == null) {
            throw new IllegalStateException("generator not initialised");
        }
        BigInteger bigInteger3 = this.c.getModulus();
        int n2 = bigInteger3.bitLength() - 1;
        do {
            bigInteger2 = BigIntegers.createRandomBigInteger(n2, this.d);
            bigInteger = bigInteger2.gcd(bigInteger3);
        } while (bigInteger2.equals(a) || bigInteger2.equals(b) || !bigInteger.equals(b));
        return bigInteger2;
    }
}

