/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.hpke;

import com.enterprisedt.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.hpke.AEAD;
import com.enterprisedt.bouncycastle.crypto.hpke.HPKEContext;
import com.enterprisedt.bouncycastle.crypto.hpke.HPKEContextWithEncapsulation;
import com.enterprisedt.bouncycastle.crypto.hpke.a;
import com.enterprisedt.bouncycastle.crypto.hpke.b;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Pack;
import com.enterprisedt.bouncycastle.util.Strings;

public class HPKE {
    public static final byte mode_base = 0;
    public static final byte mode_psk = 1;
    public static final byte mode_auth = 2;
    public static final byte mode_auth_psk = 3;
    public static final short kem_P256_SHA256 = 16;
    public static final short kem_P384_SHA348 = 17;
    public static final short kem_P521_SHA512 = 18;
    public static final short kem_X25519_SHA256 = 32;
    public static final short kem_X448_SHA512 = 33;
    public static final short kdf_HKDF_SHA256 = 1;
    public static final short kdf_HKDF_SHA384 = 2;
    public static final short kdf_HKDF_SHA512 = 3;
    public static final short aead_AES_GCM128 = 1;
    public static final short aead_AES_GCM256 = 2;
    public static final short aead_CHACHA20_POLY1305 = 3;
    public static final short aead_EXPORT_ONLY = -1;
    private final byte[] b = null;
    private final byte[] c = null;
    private final byte d;
    private final short e;
    private final short f;
    private final short g;
    private final a h;
    private final b i;
    short a;

    public HPKE(byte mode, short kemId, short kdfId, short aeadId) {
        this.d = mode;
        this.e = kemId;
        this.f = kdfId;
        this.g = aeadId;
        this.i = new b(kdfId);
        this.h = new a(kemId);
        this.a = aeadId == 1 ? (short)16 : (short)32;
    }

    private void a(byte by, byte[] byArray, byte[] byArray2) {
        boolean bl;
        boolean bl2 = !Arrays.areEqual(byArray, this.b);
        boolean bl3 = bl = !Arrays.areEqual(byArray2, this.c);
        if (bl2 != bl) {
            throw new IllegalArgumentException("Inconsistent PSK inputs");
        }
        if (bl2 && by % 2 == 0) {
            throw new IllegalArgumentException("PSK input provided when not needed");
        }
        if (!bl2 && by % 2 == 1) {
            throw new IllegalArgumentException("Missing required PSK input");
        }
    }

    private HPKEContext a(byte by, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        this.a(by, byArray3, byArray4);
        byte[] byArray5 = Arrays.concatenate(Strings.toByteArray("HPKE"), Pack.shortToBigEndian(this.e), Pack.shortToBigEndian(this.f), Pack.shortToBigEndian(this.g));
        byte[] byArray6 = this.i.a(null, byArray5, "psk_id_hash", byArray4);
        byte[] byArray7 = this.i.a(null, byArray5, "info_hash", byArray2);
        byte[] byArray8 = new byte[]{by};
        byte[] byArray9 = Arrays.concatenate(byArray8, byArray6, byArray7);
        byte[] byArray10 = this.i.a(byArray, byArray5, "secret", byArray3);
        byte[] byArray11 = this.i.a(byArray10, byArray5, "key", byArray9, this.a);
        byte[] byArray12 = this.i.a(byArray10, byArray5, "base_nonce", byArray9, 12);
        byte[] byArray13 = this.i.a(byArray10, byArray5, "exp", byArray9, this.i.a());
        return new HPKEContext(new AEAD(this.g, byArray11, byArray12), this.i, byArray13, byArray5);
    }

    public AsymmetricCipherKeyPair generatePrivateKey() {
        return this.h.a();
    }

    public byte[] serializePublicKey(AsymmetricKeyParameter pk) {
        return this.h.a(pk);
    }

    public byte[] serializePrivateKey(AsymmetricKeyParameter sk) {
        return this.h.b(sk);
    }

    public AsymmetricKeyParameter deserializePublicKey(byte[] pkEncoded) {
        return this.h.a(pkEncoded);
    }

    public AsymmetricCipherKeyPair deserializePrivateKey(byte[] skEncoded, byte[] pkEncoded) {
        return this.h.a(skEncoded, pkEncoded);
    }

    public AsymmetricCipherKeyPair deriveKeyPair(byte[] ikm) {
        return this.h.b(ikm);
    }

    public byte[][] sendExport(AsymmetricKeyParameter pkR, byte[] info, byte[] exporterContext, int L, byte[] psk, byte[] pskId, AsymmetricCipherKeyPair skS) {
        HPKEContextWithEncapsulation hPKEContextWithEncapsulation;
        byte[][] byArrayArray = new byte[2][];
        switch (this.d) {
            case 0: {
                hPKEContextWithEncapsulation = this.setupBaseS(pkR, info);
                break;
            }
            case 2: {
                hPKEContextWithEncapsulation = this.setupAuthS(pkR, info, skS);
                break;
            }
            case 1: {
                hPKEContextWithEncapsulation = this.SetupPSKS(pkR, info, psk, pskId);
                break;
            }
            case 3: {
                hPKEContextWithEncapsulation = this.setupAuthPSKS(pkR, info, psk, pskId, skS);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown mode");
            }
        }
        byArrayArray[0] = hPKEContextWithEncapsulation.a;
        byArrayArray[1] = hPKEContextWithEncapsulation.export(exporterContext, L);
        return byArrayArray;
    }

    public byte[] receiveExport(byte[] enc, AsymmetricCipherKeyPair skR, byte[] info, byte[] exporterContext, int L, byte[] psk, byte[] pskId, AsymmetricKeyParameter pkS) {
        HPKEContext hPKEContext;
        switch (this.d) {
            case 0: {
                hPKEContext = this.setupBaseR(enc, skR, info);
                break;
            }
            case 2: {
                hPKEContext = this.setupAuthR(enc, skR, info, pkS);
                break;
            }
            case 1: {
                hPKEContext = this.setupPSKR(enc, skR, info, psk, pskId);
                break;
            }
            case 3: {
                hPKEContext = this.setupAuthPSKR(enc, skR, info, psk, pskId, pkS);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown mode");
            }
        }
        return hPKEContext.export(exporterContext, L);
    }

    public byte[][] seal(AsymmetricKeyParameter pkR, byte[] info, byte[] aad, byte[] pt, byte[] psk, byte[] pskId, AsymmetricCipherKeyPair skS) throws InvalidCipherTextException {
        HPKEContextWithEncapsulation hPKEContextWithEncapsulation;
        byte[][] byArrayArray = new byte[2][];
        switch (this.d) {
            case 0: {
                hPKEContextWithEncapsulation = this.setupBaseS(pkR, info);
                break;
            }
            case 2: {
                hPKEContextWithEncapsulation = this.setupAuthS(pkR, info, skS);
                break;
            }
            case 1: {
                hPKEContextWithEncapsulation = this.SetupPSKS(pkR, info, psk, pskId);
                break;
            }
            case 3: {
                hPKEContextWithEncapsulation = this.setupAuthPSKS(pkR, info, psk, pskId, skS);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown mode");
            }
        }
        byArrayArray[0] = hPKEContextWithEncapsulation.seal(aad, pt);
        byArrayArray[1] = hPKEContextWithEncapsulation.getEncapsulation();
        return byArrayArray;
    }

    public byte[] open(byte[] enc, AsymmetricCipherKeyPair skR, byte[] info, byte[] aad, byte[] ct, byte[] psk, byte[] pskId, AsymmetricKeyParameter pkS) throws InvalidCipherTextException {
        HPKEContext hPKEContext;
        switch (this.d) {
            case 0: {
                hPKEContext = this.setupBaseR(enc, skR, info);
                break;
            }
            case 2: {
                hPKEContext = this.setupAuthR(enc, skR, info, pkS);
                break;
            }
            case 1: {
                hPKEContext = this.setupPSKR(enc, skR, info, psk, pskId);
                break;
            }
            case 3: {
                hPKEContext = this.setupAuthPSKR(enc, skR, info, psk, pskId, pkS);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown mode");
            }
        }
        return hPKEContext.open(aad, ct);
    }

    public HPKEContextWithEncapsulation setupBaseS(AsymmetricKeyParameter pkR, byte[] info) {
        byte[][] byArray = this.h.c(pkR);
        HPKEContext hPKEContext = this.a((byte)0, byArray[0], info, this.b, this.c);
        return new HPKEContextWithEncapsulation(hPKEContext, byArray[1]);
    }

    public HPKEContextWithEncapsulation setupBaseS(AsymmetricKeyParameter pkR, byte[] info, AsymmetricCipherKeyPair kpE) {
        byte[][] byArray = this.h.a(pkR, kpE);
        HPKEContext hPKEContext = this.a((byte)0, byArray[0], info, this.b, this.c);
        return new HPKEContextWithEncapsulation(hPKEContext, byArray[1]);
    }

    public HPKEContext setupBaseR(byte[] enc, AsymmetricCipherKeyPair skR, byte[] info) {
        byte[] byArray = this.h.a(enc, skR);
        return this.a((byte)0, byArray, info, this.b, this.c);
    }

    public HPKEContextWithEncapsulation SetupPSKS(AsymmetricKeyParameter pkR, byte[] info, byte[] psk, byte[] psk_id) {
        byte[][] byArray = this.h.c(pkR);
        HPKEContext hPKEContext = this.a((byte)1, byArray[0], info, psk, psk_id);
        return new HPKEContextWithEncapsulation(hPKEContext, byArray[1]);
    }

    public HPKEContext setupPSKR(byte[] enc, AsymmetricCipherKeyPair skR, byte[] info, byte[] psk, byte[] psk_id) {
        byte[] byArray = this.h.a(enc, skR);
        return this.a((byte)1, byArray, info, psk, psk_id);
    }

    public HPKEContextWithEncapsulation setupAuthS(AsymmetricKeyParameter pkR, byte[] info, AsymmetricCipherKeyPair skS) {
        byte[][] byArray = this.h.b(pkR, skS);
        HPKEContext hPKEContext = this.a((byte)2, byArray[0], info, this.b, this.c);
        return new HPKEContextWithEncapsulation(hPKEContext, byArray[1]);
    }

    public HPKEContext setupAuthR(byte[] enc, AsymmetricCipherKeyPair skR, byte[] info, AsymmetricKeyParameter pkS) {
        byte[] byArray = this.h.a(enc, skR, pkS);
        return this.a((byte)2, byArray, info, this.b, this.c);
    }

    public HPKEContextWithEncapsulation setupAuthPSKS(AsymmetricKeyParameter pkR, byte[] info, byte[] psk, byte[] psk_id, AsymmetricCipherKeyPair skS) {
        byte[][] byArray = this.h.b(pkR, skS);
        HPKEContext hPKEContext = this.a((byte)3, byArray[0], info, psk, psk_id);
        return new HPKEContextWithEncapsulation(hPKEContext, byArray[1]);
    }

    public HPKEContext setupAuthPSKR(byte[] enc, AsymmetricCipherKeyPair skR, byte[] info, byte[] psk, byte[] psk_id, AsymmetricKeyParameter pkS) {
        byte[] byArray = this.h.a(enc, skR, pkS);
        return this.a((byte)3, byArray, info, psk, psk_id);
    }
}

