/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.kems;

import com.enterprisedt.bouncycastle.crypto.CryptoServicePurpose;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.DerivationFunction;
import com.enterprisedt.bouncycastle.crypto.EncapsulatedSecretExtractor;
import com.enterprisedt.bouncycastle.crypto.constraints.ConstraintUtils;
import com.enterprisedt.bouncycastle.crypto.constraints.DefaultServiceProperties;
import com.enterprisedt.bouncycastle.crypto.kems.ECIESKEMGenerator;
import com.enterprisedt.bouncycastle.crypto.params.ECDomainParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;

public class ECIESKEMExtractor
implements EncapsulatedSecretExtractor {
    private final ECPrivateKeyParameters a;
    private int b;
    private DerivationFunction c;
    private boolean d;
    private boolean e;
    private boolean f;

    public ECIESKEMExtractor(ECPrivateKeyParameters decKey, int keyLen, DerivationFunction kdf) {
        this.a = decKey;
        this.b = keyLen;
        this.c = kdf;
        this.d = false;
        this.e = false;
        this.f = false;
    }

    public ECIESKEMExtractor(ECPrivateKeyParameters decKey, int keyLen, DerivationFunction kdf, boolean cofactorMode, boolean oldCofactorMode, boolean singleHashMode) {
        this.a = decKey;
        this.b = keyLen;
        this.c = kdf;
        this.d = cofactorMode;
        this.e = cofactorMode ? false : oldCofactorMode;
        this.f = singleHashMode;
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("ECIESKem", ConstraintUtils.bitsOfSecurityFor(this.a.getParameters().getCurve()), decKey, CryptoServicePurpose.DECRYPTION));
    }

    @Override
    public byte[] extractSecret(byte[] encapsulation) {
        ECPrivateKeyParameters eCPrivateKeyParameters = this.a;
        ECDomainParameters eCDomainParameters = eCPrivateKeyParameters.getParameters();
        ECCurve eCCurve = eCDomainParameters.getCurve();
        BigInteger bigInteger = eCDomainParameters.getN();
        BigInteger bigInteger2 = eCDomainParameters.getH();
        ECPoint eCPoint = eCCurve.decodePoint(encapsulation);
        if (this.d || this.e) {
            eCPoint = eCPoint.multiply(bigInteger2);
        }
        BigInteger bigInteger3 = eCPrivateKeyParameters.getD();
        if (this.d) {
            bigInteger3 = bigInteger3.multiply(eCDomainParameters.getHInv()).mod(bigInteger);
        }
        ECPoint eCPoint2 = eCPoint.multiply(bigInteger3).normalize();
        byte[] byArray = eCPoint2.getAffineXCoord().getEncoded();
        return ECIESKEMGenerator.a(this.f, this.c, this.b, encapsulation, byArray);
    }

    @Override
    public int getEncapsulationLength() {
        return this.a.getParameters().getCurve().getFieldSize() / 8 * 2 + 1;
    }
}

