/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.macs;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.Mac;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.digests.DSTU7564Digest;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.util.Pack;

public class DSTU7564Mac
implements Mac {
    private DSTU7564Digest a;
    private int b;
    private byte[] c;
    private byte[] d;
    private long e;

    public DSTU7564Mac(int macBitSize) {
        this.a = new DSTU7564Digest(macBitSize);
        this.b = macBitSize / 8;
        this.c = null;
        this.d = null;
    }

    @Override
    public void init(CipherParameters params) throws IllegalArgumentException {
        this.c = null;
        this.reset();
        if (params instanceof KeyParameter) {
            byte[] byArray = ((KeyParameter)params).getKey();
            this.d = new byte[byArray.length];
            this.c = this.a(byArray);
            for (int i2 = 0; i2 < this.d.length; ++i2) {
                this.d[i2] = ~byArray[i2];
            }
        } else {
            throw new IllegalArgumentException("Bad parameter passed");
        }
        this.a.update(this.c, 0, this.c.length);
    }

    @Override
    public String getAlgorithmName() {
        return "DSTU7564Mac";
    }

    @Override
    public int getMacSize() {
        return this.b;
    }

    @Override
    public void update(byte in) throws IllegalStateException {
        this.a.update(in);
        ++this.e;
    }

    @Override
    public void update(byte[] in, int inOff, int len) throws DataLengthException, IllegalStateException {
        if (in.length - inOff < len) {
            throw new DataLengthException("Input buffer too short");
        }
        if (this.c == null) {
            throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
        }
        this.a.update(in, inOff, len);
        this.e += (long)len;
    }

    @Override
    public int doFinal(byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        if (this.c == null) {
            throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
        }
        if (out.length - outOff < this.b) {
            throw new OutputLengthException("Output buffer too short");
        }
        this.a();
        this.a.update(this.d, 0, this.d.length);
        this.e = 0L;
        int n2 = this.a.doFinal(out, outOff);
        this.reset();
        return n2;
    }

    @Override
    public void reset() {
        this.e = 0L;
        this.a.reset();
        if (this.c != null) {
            this.a.update(this.c, 0, this.c.length);
        }
    }

    private void a() {
        int n2 = this.a.getByteLength() - (int)(this.e % (long)this.a.getByteLength());
        if (n2 < 13) {
            n2 += this.a.getByteLength();
        }
        byte[] byArray = new byte[n2];
        byArray[0] = -128;
        Pack.longToLittleEndian(this.e * 8L, byArray, byArray.length - 12);
        this.a.update(byArray, 0, byArray.length);
    }

    private byte[] a(byte[] byArray) {
        int n2 = (byArray.length + this.a.getByteLength() - 1) / this.a.getByteLength() * this.a.getByteLength();
        int n3 = n2 - byArray.length;
        if (n3 < 13) {
            n2 += this.a.getByteLength();
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray2[byArray.length] = -128;
        Pack.intToLittleEndian(byArray.length * 8, byArray2, byArray2.length - 12);
        return byArray2;
    }
}

