/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.macs;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.Mac;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.engines.DSTU7624Engine;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.util.Arrays;

public class DSTU7624Mac
implements Mac {
    private byte[] a;
    private int b;
    private int c;
    private int d;
    private DSTU7624Engine e;
    private byte[] f;
    private byte[] g;
    private byte[] h;
    private boolean i = false;

    public DSTU7624Mac(int blockBitLength, int q2) {
        this.e = new DSTU7624Engine(blockBitLength);
        this.d = blockBitLength / 8;
        this.c = q2 / 8;
        this.f = new byte[this.d];
        this.h = new byte[this.d];
        this.g = new byte[this.d];
        this.a = new byte[this.d];
    }

    @Override
    public void init(CipherParameters params) throws IllegalArgumentException {
        if (!(params instanceof KeyParameter)) {
            throw new IllegalArgumentException("Invalid parameter passed to DSTU7624Mac");
        }
        this.e.init(true, params);
        this.i = true;
        this.reset();
    }

    @Override
    public String getAlgorithmName() {
        return "DSTU7624Mac";
    }

    @Override
    public int getMacSize() {
        return this.c;
    }

    @Override
    public void update(byte in) {
        if (this.b == this.a.length) {
            this.a(this.a, 0);
            this.b = 0;
        }
        this.a[this.b++] = in;
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        if (len < 0) {
            throw new IllegalArgumentException("can't have a negative input length!");
        }
        int n2 = this.e.getBlockSize();
        int n3 = n2 - this.b;
        if (len > n3) {
            System.arraycopy(in, inOff, this.a, this.b, n3);
            this.a(this.a, 0);
            this.b = 0;
            len -= n3;
            inOff += n3;
            while (len > n2) {
                this.a(in, inOff);
                len -= n2;
                inOff += n2;
            }
        }
        System.arraycopy(in, inOff, this.a, this.b, len);
        this.b += len;
    }

    private void a(byte[] byArray, int n2) {
        this.a(this.f, 0, byArray, n2, this.g);
        this.e.processBlock(this.g, 0, this.f, 0);
    }

    @Override
    public int doFinal(byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        if (this.b % this.a.length != 0) {
            throw new DataLengthException("input must be a multiple of blocksize");
        }
        this.a(this.f, 0, this.a, 0, this.g);
        this.a(this.g, 0, this.h, 0, this.f);
        this.e.processBlock(this.f, 0, this.f, 0);
        if (this.c + outOff > out.length) {
            throw new OutputLengthException("output buffer too short");
        }
        System.arraycopy(this.f, 0, out, outOff, this.c);
        this.reset();
        return this.c;
    }

    @Override
    public void reset() {
        Arrays.fill(this.f, (byte)0);
        Arrays.fill(this.g, (byte)0);
        Arrays.fill(this.h, (byte)0);
        Arrays.fill(this.a, (byte)0);
        this.e.reset();
        if (this.i) {
            this.e.processBlock(this.h, 0, this.h, 0);
        }
        this.b = 0;
    }

    private void a(byte[] byArray, int n2, byte[] byArray2, int n3, byte[] byArray3) {
        if (byArray.length - n2 < this.d || byArray2.length - n3 < this.d || byArray3.length < this.d) {
            throw new IllegalArgumentException("some of input buffers too short");
        }
        for (int i2 = 0; i2 < this.d; ++i2) {
            byArray3[i2] = (byte)(byArray[i2 + n2] ^ byArray2[i2 + n3]);
        }
    }
}

