/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.macs;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.Mac;
import com.enterprisedt.bouncycastle.crypto.Xof;
import com.enterprisedt.bouncycastle.crypto.digests.CSHAKEDigest;
import com.enterprisedt.bouncycastle.crypto.digests.XofUtils;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Strings;

public class KMAC
implements Mac,
Xof {
    private static final byte[] a = new byte[100];
    private final CSHAKEDigest b;
    private final int c;
    private final int d;
    private byte[] e;
    private boolean f;
    private boolean g;

    public KMAC(int bitLength, byte[] S) {
        this.b = new CSHAKEDigest(bitLength, Strings.toByteArray("KMAC"), S);
        this.c = bitLength;
        this.d = bitLength * 2 / 8;
    }

    @Override
    public void init(CipherParameters params) throws IllegalArgumentException {
        KeyParameter keyParameter = (KeyParameter)params;
        this.e = Arrays.clone(keyParameter.getKey());
        this.f = true;
        this.reset();
    }

    @Override
    public String getAlgorithmName() {
        return "KMAC" + this.b.getAlgorithmName().substring(6);
    }

    @Override
    public int getByteLength() {
        return this.b.getByteLength();
    }

    @Override
    public int getMacSize() {
        return this.d;
    }

    @Override
    public int getDigestSize() {
        return this.d;
    }

    @Override
    public void update(byte in) throws IllegalStateException {
        if (!this.f) {
            throw new IllegalStateException("KMAC not initialized");
        }
        this.b.update(in);
    }

    @Override
    public void update(byte[] in, int inOff, int len) throws DataLengthException, IllegalStateException {
        if (!this.f) {
            throw new IllegalStateException("KMAC not initialized");
        }
        this.b.update(in, inOff, len);
    }

    @Override
    public int doFinal(byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        if (this.g) {
            if (!this.f) {
                throw new IllegalStateException("KMAC not initialized");
            }
            byte[] byArray = XofUtils.rightEncode(this.getMacSize() * 8);
            this.b.update(byArray, 0, byArray.length);
        }
        int n2 = this.b.doFinal(out, outOff, this.getMacSize());
        this.reset();
        return n2;
    }

    @Override
    public int doFinal(byte[] out, int outOff, int outLen) {
        if (this.g) {
            if (!this.f) {
                throw new IllegalStateException("KMAC not initialized");
            }
            byte[] byArray = XofUtils.rightEncode(outLen * 8);
            this.b.update(byArray, 0, byArray.length);
        }
        int n2 = this.b.doFinal(out, outOff, outLen);
        this.reset();
        return n2;
    }

    @Override
    public int doOutput(byte[] out, int outOff, int outLen) {
        if (this.g) {
            if (!this.f) {
                throw new IllegalStateException("KMAC not initialized");
            }
            byte[] byArray = XofUtils.rightEncode(0L);
            this.b.update(byArray, 0, byArray.length);
            this.g = false;
        }
        return this.b.doOutput(out, outOff, outLen);
    }

    @Override
    public void reset() {
        this.b.reset();
        if (this.e != null) {
            if (this.c == 128) {
                this.a(this.e, 168);
            } else {
                this.a(this.e, 136);
            }
        }
        this.g = true;
    }

    private void a(byte[] byArray, int n2) {
        int n3;
        byte[] byArray2 = XofUtils.leftEncode(n2);
        this.update(byArray2, 0, byArray2.length);
        byte[] byArray3 = KMAC.a(byArray);
        this.update(byArray3, 0, byArray3.length);
        if (n3 > 0 && n3 != n2) {
            for (n3 = n2 - (byArray2.length + byArray3.length) % n2; n3 > a.length; n3 -= a.length) {
                this.update(a, 0, a.length);
            }
            this.update(a, 0, n3);
        }
    }

    private static byte[] a(byte[] byArray) {
        return Arrays.concatenate(XofUtils.leftEncode(byArray.length * 8), byArray);
    }
}

