/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.macs;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.Mac;
import com.enterprisedt.bouncycastle.crypto.engines.Zuc256CoreEngine;

public final class Zuc256Mac
implements Mac {
    private final a a;
    private final int b;
    private final int[] c;
    private final int[] d;
    private Zuc256CoreEngine e;
    private int f;
    private int g;

    public Zuc256Mac(int pLength) {
        this.a = new a(pLength);
        this.b = pLength;
        int n2 = pLength / 32;
        this.c = new int[n2];
        this.d = new int[n2 + 1];
    }

    @Override
    public String getAlgorithmName() {
        return "Zuc256Mac-" + this.b;
    }

    @Override
    public int getMacSize() {
        return this.b / 8;
    }

    @Override
    public void init(CipherParameters pParams) {
        this.a.init(true, pParams);
        this.e = (Zuc256CoreEngine)this.a.copy();
        this.a();
    }

    private void a() {
        int n2;
        for (n2 = 0; n2 < this.c.length; ++n2) {
            this.c[n2] = this.a.b();
        }
        for (n2 = 0; n2 < this.d.length - 1; ++n2) {
            this.d[n2] = this.a.b();
        }
        this.f = this.d.length - 1;
        this.g = 3;
    }

    @Override
    public void update(byte in) {
        this.b();
        int n2 = this.g * 8;
        int n3 = 128;
        int n4 = 0;
        while (n3 > 0) {
            if ((in & n3) != 0) {
                this.a(n2 + n4);
            }
            n3 >>= 1;
            ++n4;
        }
    }

    private void b() {
        this.g = (this.g + 1) % 4;
        if (this.g == 0) {
            this.d[this.f] = this.a.b();
            this.f = (this.f + 1) % this.d.length;
        }
    }

    private void c() {
        this.g = (this.g + 1) % 4;
        if (this.g == 0) {
            this.f = (this.f + 1) % this.d.length;
        }
    }

    private void a(int n2) {
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            int n3 = i2;
            this.c[n3] = this.c[n3] ^ this.a(i2, n2);
        }
    }

    private int a(int n2, int n3) {
        int n4 = this.d[(this.f + n2) % this.d.length];
        if (n3 == 0) {
            return n4;
        }
        int n5 = this.d[(this.f + n2 + 1) % this.d.length];
        return n4 << n3 | n5 >>> 32 - n3;
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        for (int i2 = 0; i2 < len; ++i2) {
            this.update(in[inOff + i2]);
        }
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        this.c();
        this.a(this.g * 8);
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            Zuc256CoreEngine.encode32be(this.c[i2], out, outOff + i2 * 4);
        }
        this.reset();
        return this.getMacSize();
    }

    @Override
    public void reset() {
        if (this.e != null) {
            this.a.reset(this.e);
        }
        this.a();
    }

    private static class a
    extends Zuc256CoreEngine {
        public a(int n2) {
            super(n2);
        }

        int b() {
            return super.makeKeyStreamWord();
        }
    }
}

