/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.modes;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.Mac;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.engines.ChaCha7539Engine;
import com.enterprisedt.bouncycastle.crypto.macs.Poly1305;
import com.enterprisedt.bouncycastle.crypto.modes.AEADCipher;
import com.enterprisedt.bouncycastle.crypto.params.AEADParameters;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Pack;

public class ChaCha20Poly1305
implements AEADCipher {
    private static final byte[] a = new byte[15];
    private final ChaCha7539Engine b;
    private final Mac c;
    private final byte[] d = new byte[32];
    private final byte[] e = new byte[12];
    private final byte[] f = new byte[80];
    private final byte[] g = new byte[16];
    private byte[] h;
    private long i;
    private long j;
    private int k = 0;
    private int l;

    public ChaCha20Poly1305() {
        this(new Poly1305());
    }

    public ChaCha20Poly1305(Mac poly1305) {
        if (null == poly1305) {
            throw new NullPointerException("'poly1305' cannot be null");
        }
        if (16 != poly1305.getMacSize()) {
            throw new IllegalArgumentException("'poly1305' must be a 128-bit MAC");
        }
        this.b = new ChaCha7539Engine();
        this.c = poly1305;
    }

    @Override
    public String getAlgorithmName() {
        return "ChaCha20Poly1305";
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        ParametersWithIV parametersWithIV;
        byte[] byArray;
        KeyParameter keyParameter;
        if (params instanceof AEADParameters) {
            AEADParameters aEADParameters = (AEADParameters)params;
            int n2 = aEADParameters.getMacSize();
            if (128 != n2) {
                throw new IllegalArgumentException("Invalid value for MAC size: " + n2);
            }
            keyParameter = aEADParameters.getKey();
            byArray = aEADParameters.getNonce();
            parametersWithIV = new ParametersWithIV(keyParameter, byArray);
            this.h = aEADParameters.getAssociatedText();
        } else if (params instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV2 = (ParametersWithIV)params;
            keyParameter = (KeyParameter)parametersWithIV2.getParameters();
            byArray = parametersWithIV2.getIV();
            parametersWithIV = parametersWithIV2;
            this.h = null;
        } else {
            throw new IllegalArgumentException("invalid parameters passed to ChaCha20Poly1305");
        }
        if (null == keyParameter) {
            if (0 == this.k) {
                throw new IllegalArgumentException("Key must be specified in initial init");
            }
        } else if (32 != keyParameter.getKeyLength()) {
            throw new IllegalArgumentException("Key must be 256 bits");
        }
        if (null == byArray || 12 != byArray.length) {
            throw new IllegalArgumentException("Nonce must be 96 bits");
        }
        if (0 != this.k && forEncryption && Arrays.areEqual(this.e, byArray) && (null == keyParameter || Arrays.areEqual(this.d, keyParameter.getKey()))) {
            throw new IllegalArgumentException("cannot reuse nonce for ChaCha20Poly1305 encryption");
        }
        if (null != keyParameter) {
            keyParameter.copyTo(this.d, 0, 32);
        }
        System.arraycopy(byArray, 0, this.e, 0, 12);
        this.b.init(true, parametersWithIV);
        this.k = forEncryption ? 1 : 5;
        this.a(true, false);
    }

    @Override
    public int getOutputSize(int len) {
        int n2 = Math.max(0, len) + this.l;
        switch (this.k) {
            case 5: 
            case 6: 
            case 7: {
                return Math.max(0, n2 - 16);
            }
            case 1: 
            case 2: 
            case 3: {
                return n2 + 16;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public int getUpdateOutputSize(int len) {
        int n2 = Math.max(0, len) + this.l;
        switch (this.k) {
            case 5: 
            case 6: 
            case 7: {
                n2 = Math.max(0, n2 - 16);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return n2 - n2 % 64;
    }

    @Override
    public void processAADByte(byte in) {
        this.a();
        this.i = this.a(this.i, 1, -1L);
        this.c.update(in);
    }

    @Override
    public void processAADBytes(byte[] in, int inOff, int len) {
        if (null == in) {
            throw new NullPointerException("'in' cannot be null");
        }
        if (inOff < 0) {
            throw new IllegalArgumentException("'inOff' cannot be negative");
        }
        if (len < 0) {
            throw new IllegalArgumentException("'len' cannot be negative");
        }
        if (inOff > in.length - len) {
            throw new DataLengthException("Input buffer too short");
        }
        this.a();
        if (len > 0) {
            this.i = this.a(this.i, len, -1L);
            this.c.update(in, inOff, len);
        }
    }

    @Override
    public int processByte(byte in, byte[] out, int outOff) throws DataLengthException {
        this.b();
        switch (this.k) {
            case 7: {
                this.f[this.l] = in;
                if (++this.l == this.f.length) {
                    this.c.update(this.f, 0, 64);
                    this.a(this.f, 0, 64, out, outOff);
                    System.arraycopy(this.f, 64, this.f, 0, 16);
                    this.l = 16;
                    return 64;
                }
                return 0;
            }
            case 3: {
                this.f[this.l] = in;
                if (++this.l == 64) {
                    this.a(this.f, 0, 64, out, outOff);
                    this.c.update(out, outOff, 64);
                    this.l = 0;
                    return 64;
                }
                return 0;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public int processBytes(byte[] in, int inOff, int len, byte[] out, int outOff) throws DataLengthException {
        if (null == in) {
            throw new NullPointerException("'in' cannot be null");
        }
        if (null == out) {
            // empty if block
        }
        if (inOff < 0) {
            throw new IllegalArgumentException("'inOff' cannot be negative");
        }
        if (len < 0) {
            throw new IllegalArgumentException("'len' cannot be negative");
        }
        if (inOff > in.length - len) {
            throw new DataLengthException("Input buffer too short");
        }
        if (outOff < 0) {
            throw new IllegalArgumentException("'outOff' cannot be negative");
        }
        this.b();
        int n2 = 0;
        switch (this.k) {
            case 7: {
                for (int i2 = 0; i2 < len; ++i2) {
                    this.f[this.l] = in[inOff + i2];
                    if (++this.l != this.f.length) continue;
                    this.c.update(this.f, 0, 64);
                    this.a(this.f, 0, 64, out, outOff + n2);
                    System.arraycopy(this.f, 64, this.f, 0, 16);
                    this.l = 16;
                    n2 += 64;
                }
                break;
            }
            case 3: {
                if (this.l != 0) {
                    while (len > 0) {
                        --len;
                        this.f[this.l] = in[inOff++];
                        if (++this.l != 64) continue;
                        this.a(this.f, 0, 64, out, outOff);
                        this.c.update(out, outOff, 64);
                        this.l = 0;
                        n2 = 64;
                        break;
                    }
                }
                while (len >= 64) {
                    this.a(in, inOff, 64, out, outOff + n2);
                    this.c.update(out, outOff + n2, 64);
                    inOff += 64;
                    len -= 64;
                    n2 += 64;
                }
                if (len <= 0) break;
                System.arraycopy(in, inOff, this.f, 0, len);
                this.l = len;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return n2;
    }

    @Override
    public int doFinal(byte[] out, int outOff) throws IllegalStateException, InvalidCipherTextException {
        if (null == out) {
            throw new NullPointerException("'out' cannot be null");
        }
        if (outOff < 0) {
            throw new IllegalArgumentException("'outOff' cannot be negative");
        }
        this.b();
        Arrays.clear(this.g);
        int n2 = 0;
        switch (this.k) {
            case 7: {
                if (this.l < 16) {
                    throw new InvalidCipherTextException("data too short");
                }
                n2 = this.l - 16;
                if (outOff > out.length - n2) {
                    throw new OutputLengthException("Output buffer too short");
                }
                if (n2 > 0) {
                    this.c.update(this.f, 0, n2);
                    this.a(this.f, 0, n2, out, outOff);
                }
                this.b(8);
                if (Arrays.constantTimeAreEqual(16, this.g, 0, this.f, n2)) break;
                throw new InvalidCipherTextException("mac check in ChaCha20Poly1305 failed");
            }
            case 3: {
                n2 = this.l + 16;
                if (outOff > out.length - n2) {
                    throw new OutputLengthException("Output buffer too short");
                }
                if (this.l > 0) {
                    this.a(this.f, 0, this.l, out, outOff);
                    this.c.update(out, outOff, this.l);
                }
                this.b(4);
                System.arraycopy(this.g, 0, out, outOff + this.l, 16);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.a(false, true);
        return n2;
    }

    @Override
    public byte[] getMac() {
        return Arrays.clone(this.g);
    }

    @Override
    public void reset() {
        this.a(true, true);
    }

    private void a() {
        switch (this.k) {
            case 5: {
                this.k = 6;
                break;
            }
            case 1: {
                this.k = 2;
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 4: {
                throw new IllegalStateException("ChaCha20Poly1305 cannot be reused for encryption");
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void b() {
        switch (this.k) {
            case 5: 
            case 6: {
                this.a(7);
                break;
            }
            case 1: 
            case 2: {
                this.a(3);
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 4: {
                throw new IllegalStateException("ChaCha20Poly1305 cannot be reused for encryption");
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void a(int n2) {
        this.a(this.i);
        this.k = n2;
    }

    private void b(int n2) {
        this.a(this.j);
        byte[] byArray = new byte[16];
        Pack.longToLittleEndian(this.i, byArray, 0);
        Pack.longToLittleEndian(this.j, byArray, 8);
        this.c.update(byArray, 0, 16);
        this.c.doFinal(this.g, 0);
        this.k = n2;
    }

    private long a(long l2, int n2, long l3) {
        if (l2 + Long.MIN_VALUE > l3 - (long)n2 + Long.MIN_VALUE) {
            throw new IllegalStateException("Limit exceeded");
        }
        return l2 + (long)n2;
    }

    private void c() {
        byte[] byArray = new byte[64];
        try {
            this.b.processBytes(byArray, 0, 64, byArray, 0);
            this.c.init(new KeyParameter(byArray, 0, 32));
        }
        finally {
            Arrays.clear(byArray);
        }
    }

    private void a(long l2) {
        int n2 = (int)l2 & 0xF;
        if (0 != n2) {
            this.c.update(a, 0, 16 - n2);
        }
    }

    private void a(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        if (n4 > byArray2.length - n3) {
            throw new OutputLengthException("Output buffer too short");
        }
        this.b.processBytes(byArray, n2, n3, byArray2, n4);
        this.j = this.a(this.j, n3, 274877906880L);
    }

    private void a(boolean bl, boolean bl2) {
        Arrays.clear(this.f);
        if (bl) {
            Arrays.clear(this.g);
        }
        this.i = 0L;
        this.j = 0L;
        this.l = 0;
        switch (this.k) {
            case 1: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                this.k = 5;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.k = 4;
                return;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (bl2) {
            this.b.reset();
        }
        this.c();
        if (null != this.h) {
            this.processAADBytes(this.h, 0, this.h.length);
        }
    }
}

