/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.modes;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.StreamBlockCipher;
import com.enterprisedt.bouncycastle.crypto.modes.a;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.util.Arrays;

public class G3413CTRBlockCipher
extends StreamBlockCipher {
    private final int a;
    private byte[] b;
    private byte[] c;
    private byte[] d;
    private final int e;
    private final BlockCipher f;
    private int g = 0;
    private boolean h;

    public G3413CTRBlockCipher(BlockCipher cipher) {
        this(cipher, cipher.getBlockSize() * 8);
    }

    public G3413CTRBlockCipher(BlockCipher cipher, int bitBlockSize) {
        super(cipher);
        if (bitBlockSize < 0 || bitBlockSize > cipher.getBlockSize() * 8) {
            throw new IllegalArgumentException("Parameter bitBlockSize must be in range 0 < bitBlockSize <= " + cipher.getBlockSize() * 8);
        }
        this.f = cipher;
        this.e = cipher.getBlockSize();
        this.a = bitBlockSize / 8;
        this.b = new byte[this.e];
    }

    @Override
    public void init(boolean encrypting, CipherParameters params) throws IllegalArgumentException {
        if (params instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)params;
            this.a();
            this.c = Arrays.clone(parametersWithIV.getIV());
            if (this.c.length != this.e / 2) {
                throw new IllegalArgumentException("Parameter IV length must be == blockSize/2");
            }
            System.arraycopy(this.c, 0, this.b, 0, this.c.length);
            for (int i2 = this.c.length; i2 < this.e; ++i2) {
                this.b[i2] = 0;
            }
            if (parametersWithIV.getParameters() != null) {
                this.f.init(true, parametersWithIV.getParameters());
            }
        } else {
            this.a();
            if (params != null) {
                this.f.init(true, params);
            }
        }
        this.h = true;
    }

    private void a() {
        this.c = new byte[this.e / 2];
        this.b = new byte[this.e];
        this.d = new byte[this.a];
    }

    @Override
    public String getAlgorithmName() {
        return this.f.getAlgorithmName() + "/GCTR";
    }

    @Override
    public int getBlockSize() {
        return this.a;
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        this.processBytes(in, inOff, this.a, out, outOff);
        return this.a;
    }

    @Override
    protected byte calculateByte(byte in) {
        if (this.g == 0) {
            this.d = this.c();
        }
        byte by = (byte)(this.d[this.g] ^ in);
        ++this.g;
        if (this.g == this.a) {
            this.g = 0;
            this.b();
        }
        return by;
    }

    private void b() {
        int n2 = this.b.length - 1;
        this.b[n2] = (byte)(this.b[n2] + 1);
    }

    private byte[] c() {
        byte[] byArray = new byte[this.b.length];
        this.f.processBlock(this.b, 0, byArray, 0);
        return com.enterprisedt.bouncycastle.crypto.modes.a.a(byArray, this.a);
    }

    @Override
    public void reset() {
        if (this.h) {
            System.arraycopy(this.c, 0, this.b, 0, this.c.length);
            for (int i2 = this.c.length; i2 < this.e; ++i2) {
                this.b[i2] = 0;
            }
            this.g = 0;
            this.f.reset();
        }
    }
}

