/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.modes;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.BufferedBlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.modes.AEADBlockCipher;
import com.enterprisedt.bouncycastle.crypto.modes.KCTRBlockCipher;
import com.enterprisedt.bouncycastle.crypto.modes.kgcm.KGCMMultiplier;
import com.enterprisedt.bouncycastle.crypto.modes.kgcm.Tables16kKGCMMultiplier_512;
import com.enterprisedt.bouncycastle.crypto.modes.kgcm.Tables4kKGCMMultiplier_128;
import com.enterprisedt.bouncycastle.crypto.modes.kgcm.Tables8kKGCMMultiplier_256;
import com.enterprisedt.bouncycastle.crypto.params.AEADParameters;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Pack;
import java.io.ByteArrayOutputStream;

public class KGCMBlockCipher
implements AEADBlockCipher {
    private BlockCipher a;
    private BufferedBlockCipher b;
    private int c;
    private boolean d;
    private byte[] e;
    private byte[] f;
    private byte[] g;
    private KGCMMultiplier h;
    private long[] i;
    private final int j;
    private a k = new a();
    private a l = new a();

    private static KGCMMultiplier a(int n2) {
        switch (n2) {
            case 16: {
                return new Tables4kKGCMMultiplier_128();
            }
            case 32: {
                return new Tables8kKGCMMultiplier_256();
            }
            case 64: {
                return new Tables16kKGCMMultiplier_512();
            }
        }
        throw new IllegalArgumentException("Only 128, 256, and 512 -bit block sizes supported");
    }

    public KGCMBlockCipher(BlockCipher dstu7624Engine) {
        this.a = dstu7624Engine;
        this.b = new BufferedBlockCipher(new KCTRBlockCipher(this.a));
        this.c = -1;
        this.j = this.a.getBlockSize();
        this.e = new byte[this.j];
        this.g = new byte[this.j];
        this.h = KGCMBlockCipher.a(this.j);
        this.i = new long[this.j >>> 3];
        this.f = null;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        KeyParameter keyParameter;
        this.d = forEncryption;
        if (params instanceof AEADParameters) {
            AEADParameters aEADParameters = (AEADParameters)params;
            byte[] byArray = aEADParameters.getNonce();
            int n2 = this.g.length - byArray.length;
            Arrays.fill(this.g, (byte)0);
            System.arraycopy(byArray, 0, this.g, n2, byArray.length);
            this.e = aEADParameters.getAssociatedText();
            int n3 = aEADParameters.getMacSize();
            if (n3 < 64 || n3 > this.j << 3 || (n3 & 7) != 0) {
                throw new IllegalArgumentException("Invalid value for MAC size: " + n3);
            }
            this.c = n3 >>> 3;
            keyParameter = aEADParameters.getKey();
            if (this.e != null) {
                this.processAADBytes(this.e, 0, this.e.length);
            }
        } else if (params instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)params;
            byte[] byArray = parametersWithIV.getIV();
            int n4 = this.g.length - byArray.length;
            Arrays.fill(this.g, (byte)0);
            System.arraycopy(byArray, 0, this.g, n4, byArray.length);
            this.e = null;
            this.c = this.j;
            keyParameter = (KeyParameter)parametersWithIV.getParameters();
        } else {
            throw new IllegalArgumentException("Invalid parameter passed");
        }
        this.f = new byte[this.j];
        this.b.init(true, new ParametersWithIV(keyParameter, this.g));
        this.a.init(true, keyParameter);
    }

    @Override
    public String getAlgorithmName() {
        return this.a.getAlgorithmName() + "/KGCM";
    }

    @Override
    public BlockCipher getUnderlyingCipher() {
        return this.a;
    }

    @Override
    public void processAADByte(byte in) {
        this.k.write(in);
    }

    @Override
    public void processAADBytes(byte[] in, int inOff, int len) {
        this.k.write(in, inOff, len);
    }

    private void a(byte[] byArray, int n2, int n3) {
        int n4 = n2 + n3;
        for (int i2 = n2; i2 < n4; i2 += this.j) {
            KGCMBlockCipher.a(this.i, byArray, i2);
            this.h.multiplyH(this.i);
        }
    }

    @Override
    public int processByte(byte in, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        this.l.write(in);
        return 0;
    }

    @Override
    public int processBytes(byte[] in, int inOff, int inLen, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        if (in.length < inOff + inLen) {
            throw new DataLengthException("input buffer too short");
        }
        this.l.write(in, inOff, inLen);
        return 0;
    }

    @Override
    public int doFinal(byte[] out, int outOff) throws IllegalStateException, InvalidCipherTextException {
        int n2;
        int n3 = this.l.size();
        if (!this.d && n3 < this.c) {
            throw new InvalidCipherTextException("data too short");
        }
        byte[] byArray = new byte[this.j];
        this.a.processBlock(byArray, 0, byArray, 0);
        long[] lArray = new long[this.j >>> 3];
        Pack.littleEndianToLong(byArray, 0, lArray);
        this.h.init(lArray);
        Arrays.fill(byArray, (byte)0);
        Arrays.fill(lArray, 0L);
        int n4 = this.k.size();
        if (n4 > 0) {
            this.a(this.k.a(), 0, n4);
        }
        if (this.d) {
            if (out.length - outOff - this.c < n3) {
                throw new OutputLengthException("Output buffer too short");
            }
            n2 = this.b.processBytes(this.l.a(), 0, n3, out, outOff);
            n2 += this.b.doFinal(out, outOff + n2);
            this.a(out, outOff, n3, n4);
        } else {
            int n5 = n3 - this.c;
            if (out.length - outOff < n5) {
                throw new OutputLengthException("Output buffer too short");
            }
            this.a(this.l.a(), 0, n5, n4);
            n2 = this.b.processBytes(this.l.a(), 0, n5, out, outOff);
            n2 += this.b.doFinal(out, outOff + n2);
        }
        if (this.f == null) {
            throw new IllegalStateException("mac is not calculated");
        }
        if (this.d) {
            System.arraycopy(this.f, 0, out, outOff + n2, this.c);
            this.reset();
            return n2 + this.c;
        }
        byte[] byArray2 = new byte[this.c];
        System.arraycopy(this.l.a(), n3 - this.c, byArray2, 0, this.c);
        byte[] byArray3 = new byte[this.c];
        System.arraycopy(this.f, 0, byArray3, 0, this.c);
        if (!Arrays.constantTimeAreEqual(byArray2, byArray3)) {
            throw new InvalidCipherTextException("mac verification failed");
        }
        this.reset();
        return n2;
    }

    @Override
    public byte[] getMac() {
        byte[] byArray = new byte[this.c];
        System.arraycopy(this.f, 0, byArray, 0, this.c);
        return byArray;
    }

    @Override
    public int getUpdateOutputSize(int len) {
        return 0;
    }

    @Override
    public int getOutputSize(int len) {
        int n2 = len + this.l.size();
        if (this.d) {
            return n2 + this.c;
        }
        return n2 < this.c ? 0 : n2 - this.c;
    }

    @Override
    public void reset() {
        Arrays.fill(this.i, 0L);
        this.a.reset();
        this.l.reset();
        this.k.reset();
        if (this.e != null) {
            this.processAADBytes(this.e, 0, this.e.length);
        }
    }

    private void a(byte[] byArray, int n2, int n3, int n4) {
        int n5 = n2 + n3;
        for (int i2 = n2; i2 < n5; i2 += this.j) {
            KGCMBlockCipher.a(this.i, byArray, i2);
            this.h.multiplyH(this.i);
        }
        long l2 = ((long)n4 & 0xFFFFFFFFL) << 3;
        long l3 = ((long)n3 & 0xFFFFFFFFL) << 3;
        this.i[0] = this.i[0] ^ l2;
        int n6 = this.j >>> 4;
        this.i[n6] = this.i[n6] ^ l3;
        this.f = Pack.longToLittleEndian(this.i);
        this.a.processBlock(this.f, 0, this.f, 0);
    }

    private static void a(long[] lArray, byte[] byArray, int n2) {
        int n3 = 0;
        while (n3 < lArray.length) {
            int n4 = n3++;
            lArray[n4] = lArray[n4] ^ Pack.littleEndianToLong(byArray, n2);
            n2 += 8;
        }
    }

    private static class a
    extends ByteArrayOutputStream {
        public byte[] a() {
            return this.buf;
        }
    }
}

