/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.modes.gcm;

import com.enterprisedt.bouncycastle.crypto.modes.gcm.GCMExponentiator;
import com.enterprisedt.bouncycastle.crypto.modes.gcm.GCMUtil;

public class BasicGCMExponentiator
implements GCMExponentiator {
    private long[] a;

    @Override
    public void init(byte[] x) {
        this.a = GCMUtil.asLongs(x);
    }

    @Override
    public void exponentiateX(long pow, byte[] output) {
        long[] lArray = GCMUtil.oneAsLongs();
        if (pow > 0L) {
            long[] lArray2 = new long[2];
            GCMUtil.copy(this.a, lArray2);
            do {
                if ((pow & 1L) != 0L) {
                    GCMUtil.multiply(lArray, lArray2);
                }
                GCMUtil.square(lArray2, lArray2);
            } while ((pow >>>= 1) > 0L);
        }
        GCMUtil.asBytes(lArray, output);
    }
}

