/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.modes.gcm;

import com.enterprisedt.bouncycastle.math.raw.Interleave;
import com.enterprisedt.bouncycastle.util.Longs;
import com.enterprisedt.bouncycastle.util.Pack;

public abstract class GCMUtil {
    public static final int SIZE_BYTES = 16;
    public static final int SIZE_INTS = 4;
    public static final int SIZE_LONGS = 2;

    public static byte[] oneAsBytes() {
        byte[] byArray = new byte[16];
        byArray[0] = -128;
        return byArray;
    }

    public static int[] oneAsInts() {
        int[] nArray = new int[4];
        nArray[0] = Integer.MIN_VALUE;
        return nArray;
    }

    public static long[] oneAsLongs() {
        long[] lArray = new long[2];
        lArray[0] = Long.MIN_VALUE;
        return lArray;
    }

    public static byte areEqual(byte[] x, byte[] y) {
        int n2 = 0;
        for (int i2 = 0; i2 < 16; ++i2) {
            n2 |= x[i2] ^ y[i2];
        }
        n2 = n2 >>> 1 | n2 & 1;
        return (byte)(n2 - 1 >> 31);
    }

    public static int areEqual(int[] x, int[] y) {
        int n2 = 0;
        n2 |= x[0] ^ y[0];
        n2 |= x[1] ^ y[1];
        n2 |= x[2] ^ y[2];
        n2 |= x[3] ^ y[3];
        n2 = n2 >>> 1 | n2 & 1;
        return n2 - 1 >> 31;
    }

    public static long areEqual(long[] x, long[] y) {
        long l2 = 0L;
        l2 |= x[0] ^ y[0];
        l2 |= x[1] ^ y[1];
        l2 = l2 >>> 1 | l2 & 1L;
        return l2 - 1L >> 63;
    }

    public static byte[] asBytes(int[] x) {
        byte[] byArray = new byte[16];
        Pack.intToBigEndian(x, 0, 4, byArray, 0);
        return byArray;
    }

    public static void asBytes(int[] x, byte[] z) {
        Pack.intToBigEndian(x, 0, 4, z, 0);
    }

    public static byte[] asBytes(long[] x) {
        byte[] byArray = new byte[16];
        Pack.longToBigEndian(x, 0, 2, byArray, 0);
        return byArray;
    }

    public static void asBytes(long[] x, byte[] z) {
        Pack.longToBigEndian(x, 0, 2, z, 0);
    }

    public static int[] asInts(byte[] x) {
        int[] nArray = new int[4];
        Pack.bigEndianToInt(x, 0, nArray, 0, 4);
        return nArray;
    }

    public static void asInts(byte[] x, int[] z) {
        Pack.bigEndianToInt(x, 0, z, 0, 4);
    }

    public static long[] asLongs(byte[] x) {
        long[] lArray = new long[2];
        Pack.bigEndianToLong(x, 0, lArray, 0, 2);
        return lArray;
    }

    public static void asLongs(byte[] x, long[] z) {
        Pack.bigEndianToLong(x, 0, z, 0, 2);
    }

    public static void copy(byte[] x, byte[] z) {
        for (int i2 = 0; i2 < 16; ++i2) {
            z[i2] = x[i2];
        }
    }

    public static void copy(int[] x, int[] z) {
        z[0] = x[0];
        z[1] = x[1];
        z[2] = x[2];
        z[3] = x[3];
    }

    public static void copy(long[] x, long[] z) {
        z[0] = x[0];
        z[1] = x[1];
    }

    public static void divideP(long[] x, long[] z) {
        long l2 = x[0];
        long l3 = x[1];
        long l4 = l2 >> 63;
        z[0] = (l2 ^= l4 & 0xE100000000000000L) << 1 | l3 >>> 63;
        z[1] = l3 << 1 | -l4;
    }

    public static void multiply(byte[] x, byte[] y) {
        long[] lArray = GCMUtil.asLongs(x);
        long[] lArray2 = GCMUtil.asLongs(y);
        GCMUtil.multiply(lArray, lArray2);
        GCMUtil.asBytes(lArray, x);
    }

    static void a(byte[] byArray, long[] lArray) {
        long l2 = Pack.bigEndianToLong(byArray, 0);
        long l3 = Pack.bigEndianToLong(byArray, 8);
        long l4 = lArray[0];
        long l5 = lArray[1];
        long l6 = Longs.reverse(l2);
        long l7 = Longs.reverse(l3);
        long l8 = Longs.reverse(l4);
        long l9 = Longs.reverse(l5);
        long l10 = Longs.reverse(GCMUtil.a(l6, l8));
        long l11 = GCMUtil.a(l2, l4) << 1;
        long l12 = Longs.reverse(GCMUtil.a(l7, l9));
        long l13 = GCMUtil.a(l3, l5) << 1;
        long l14 = Longs.reverse(GCMUtil.a(l6 ^ l7, l8 ^ l9));
        long l15 = GCMUtil.a(l2 ^ l3, l4 ^ l5) << 1;
        long l16 = l10;
        long l17 = l11 ^ l10 ^ l12 ^ l14;
        long l18 = l12 ^ l11 ^ l13 ^ l15;
        long l19 = l13;
        l17 ^= l19 ^ l19 >>> 1 ^ l19 >>> 2 ^ l19 >>> 7;
        Pack.longToBigEndian(l16 ^= (l18 ^= l19 << 62 ^ l19 << 57) ^ l18 >>> 1 ^ l18 >>> 2 ^ l18 >>> 7, byArray, 0);
        Pack.longToBigEndian(l17 ^= l18 << 63 ^ l18 << 62 ^ l18 << 57, byArray, 8);
    }

    public static void multiply(int[] x, int[] y) {
        int n2 = y[0];
        int n3 = y[1];
        int n4 = y[2];
        int n5 = y[3];
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            int n10 = x[i2];
            for (int i3 = 0; i3 < 32; ++i3) {
                int n11 = n10 >> 31;
                n10 <<= 1;
                n6 ^= n2 & n11;
                n7 ^= n3 & n11;
                n8 ^= n4 & n11;
                n9 ^= n5 & n11;
                int n12 = n5 << 31 >> 8;
                n5 = n5 >>> 1 | n4 << 31;
                n4 = n4 >>> 1 | n3 << 31;
                n3 = n3 >>> 1 | n2 << 31;
                n2 = n2 >>> 1 ^ n12 & 0xE1000000;
            }
        }
        x[0] = n6;
        x[1] = n7;
        x[2] = n8;
        x[3] = n9;
    }

    public static void multiply(long[] x, long[] y) {
        long l2 = x[0];
        long l3 = x[1];
        long l4 = y[0];
        long l5 = y[1];
        long l6 = Longs.reverse(l2);
        long l7 = Longs.reverse(l3);
        long l8 = Longs.reverse(l4);
        long l9 = Longs.reverse(l5);
        long l10 = Longs.reverse(GCMUtil.a(l6, l8));
        long l11 = GCMUtil.a(l2, l4) << 1;
        long l12 = Longs.reverse(GCMUtil.a(l7, l9));
        long l13 = GCMUtil.a(l3, l5) << 1;
        long l14 = Longs.reverse(GCMUtil.a(l6 ^ l7, l8 ^ l9));
        long l15 = GCMUtil.a(l2 ^ l3, l4 ^ l5) << 1;
        long l16 = l10;
        long l17 = l11 ^ l10 ^ l12 ^ l14;
        long l18 = l12 ^ l11 ^ l13 ^ l15;
        long l19 = l13;
        l17 ^= l19 ^ l19 >>> 1 ^ l19 >>> 2 ^ l19 >>> 7;
        x[0] = l16 ^= (l18 ^= l19 << 62 ^ l19 << 57) ^ l18 >>> 1 ^ l18 >>> 2 ^ l18 >>> 7;
        x[1] = l17 ^= l18 << 63 ^ l18 << 62 ^ l18 << 57;
    }

    public static void multiplyP(int[] x) {
        int n2 = x[0];
        int n3 = x[1];
        int n4 = x[2];
        int n5 = x[3];
        int n6 = n5 << 31 >> 31;
        x[0] = n2 >>> 1 ^ n6 & 0xE1000000;
        x[1] = n3 >>> 1 | n2 << 31;
        x[2] = n4 >>> 1 | n3 << 31;
        x[3] = n5 >>> 1 | n4 << 31;
    }

    public static void multiplyP(int[] x, int[] z) {
        int n2 = x[0];
        int n3 = x[1];
        int n4 = x[2];
        int n5 = x[3];
        int n6 = n5 << 31 >> 31;
        z[0] = n2 >>> 1 ^ n6 & 0xE1000000;
        z[1] = n3 >>> 1 | n2 << 31;
        z[2] = n4 >>> 1 | n3 << 31;
        z[3] = n5 >>> 1 | n4 << 31;
    }

    public static void multiplyP(long[] x) {
        long l2 = x[0];
        long l3 = x[1];
        long l4 = l3 << 63 >> 63;
        x[0] = l2 >>> 1 ^ l4 & 0xE100000000000000L;
        x[1] = l3 >>> 1 | l2 << 63;
    }

    public static void multiplyP(long[] x, long[] z) {
        long l2 = x[0];
        long l3 = x[1];
        long l4 = l3 << 63 >> 63;
        z[0] = l2 >>> 1 ^ l4 & 0xE100000000000000L;
        z[1] = l3 >>> 1 | l2 << 63;
    }

    public static void multiplyP3(long[] x, long[] z) {
        long l2 = x[0];
        long l3 = x[1];
        long l4 = l3 << 61;
        z[0] = l2 >>> 3 ^ l4 ^ l4 >>> 1 ^ l4 >>> 2 ^ l4 >>> 7;
        z[1] = l3 >>> 3 | l2 << 61;
    }

    public static void multiplyP4(long[] x, long[] z) {
        long l2 = x[0];
        long l3 = x[1];
        long l4 = l3 << 60;
        z[0] = l2 >>> 4 ^ l4 ^ l4 >>> 1 ^ l4 >>> 2 ^ l4 >>> 7;
        z[1] = l3 >>> 4 | l2 << 60;
    }

    public static void multiplyP7(long[] x, long[] z) {
        long l2 = x[0];
        long l3 = x[1];
        long l4 = l3 << 57;
        z[0] = l2 >>> 7 ^ l4 ^ l4 >>> 1 ^ l4 >>> 2 ^ l4 >>> 7;
        z[1] = l3 >>> 7 | l2 << 57;
    }

    public static void multiplyP8(int[] x) {
        int n2 = x[0];
        int n3 = x[1];
        int n4 = x[2];
        int n5 = x[3];
        int n6 = n5 << 24;
        x[0] = n2 >>> 8 ^ n6 ^ n6 >>> 1 ^ n6 >>> 2 ^ n6 >>> 7;
        x[1] = n3 >>> 8 | n2 << 24;
        x[2] = n4 >>> 8 | n3 << 24;
        x[3] = n5 >>> 8 | n4 << 24;
    }

    public static void multiplyP8(int[] x, int[] y) {
        int n2 = x[0];
        int n3 = x[1];
        int n4 = x[2];
        int n5 = x[3];
        int n6 = n5 << 24;
        y[0] = n2 >>> 8 ^ n6 ^ n6 >>> 1 ^ n6 >>> 2 ^ n6 >>> 7;
        y[1] = n3 >>> 8 | n2 << 24;
        y[2] = n4 >>> 8 | n3 << 24;
        y[3] = n5 >>> 8 | n4 << 24;
    }

    public static void multiplyP8(long[] x) {
        long l2 = x[0];
        long l3 = x[1];
        long l4 = l3 << 56;
        x[0] = l2 >>> 8 ^ l4 ^ l4 >>> 1 ^ l4 >>> 2 ^ l4 >>> 7;
        x[1] = l3 >>> 8 | l2 << 56;
    }

    public static void multiplyP8(long[] x, long[] y) {
        long l2 = x[0];
        long l3 = x[1];
        long l4 = l3 << 56;
        y[0] = l2 >>> 8 ^ l4 ^ l4 >>> 1 ^ l4 >>> 2 ^ l4 >>> 7;
        y[1] = l3 >>> 8 | l2 << 56;
    }

    public static void multiplyP16(long[] x) {
        long l2 = x[0];
        long l3 = x[1];
        long l4 = l3 << 48;
        x[0] = l2 >>> 16 ^ l4 ^ l4 >>> 1 ^ l4 >>> 2 ^ l4 >>> 7;
        x[1] = l3 >>> 16 | l2 << 48;
    }

    public static long[] pAsLongs() {
        long[] lArray = new long[2];
        lArray[0] = 0x4000000000000000L;
        return lArray;
    }

    public static void square(long[] x, long[] z) {
        long[] lArray = new long[4];
        Interleave.expand64To128Rev(x[0], lArray, 0);
        Interleave.expand64To128Rev(x[1], lArray, 2);
        long l2 = lArray[0];
        long l3 = lArray[1];
        long l4 = lArray[2];
        long l5 = lArray[3];
        l3 ^= l5 ^ l5 >>> 1 ^ l5 >>> 2 ^ l5 >>> 7;
        z[0] = l2 ^= (l4 ^= l5 << 63 ^ l5 << 62 ^ l5 << 57) ^ l4 >>> 1 ^ l4 >>> 2 ^ l4 >>> 7;
        z[1] = l3 ^= l4 << 63 ^ l4 << 62 ^ l4 << 57;
    }

    public static void xor(byte[] x, byte[] y) {
        int n2 = 0;
        do {
            int n3 = n2;
            x[n3] = (byte)(x[n3] ^ y[n2]);
            int n4 = ++n2;
            x[n4] = (byte)(x[n4] ^ y[n2]);
            int n5 = ++n2;
            x[n5] = (byte)(x[n5] ^ y[n2]);
            int n6 = ++n2;
            x[n6] = (byte)(x[n6] ^ y[n2]);
        } while (++n2 < 16);
    }

    public static void xor(byte[] x, byte[] y, int yOff) {
        int n2 = 0;
        do {
            int n3 = n2;
            x[n3] = (byte)(x[n3] ^ y[yOff + n2]);
            int n4 = ++n2;
            x[n4] = (byte)(x[n4] ^ y[yOff + n2]);
            int n5 = ++n2;
            x[n5] = (byte)(x[n5] ^ y[yOff + n2]);
            int n6 = ++n2;
            x[n6] = (byte)(x[n6] ^ y[yOff + n2]);
        } while (++n2 < 16);
    }

    public static void xor(byte[] x, int xOff, byte[] y, int yOff, byte[] z, int zOff) {
        int n2 = 0;
        do {
            z[zOff + n2] = (byte)(x[xOff + n2] ^ y[yOff + n2]);
            z[zOff + ++n2] = (byte)(x[xOff + n2] ^ y[yOff + n2]);
            z[zOff + ++n2] = (byte)(x[xOff + n2] ^ y[yOff + n2]);
            z[zOff + ++n2] = (byte)(x[xOff + n2] ^ y[yOff + n2]);
        } while (++n2 < 16);
    }

    public static void xor(byte[] x, byte[] y, int yOff, int yLen) {
        while (--yLen >= 0) {
            int n2 = yLen;
            x[n2] = (byte)(x[n2] ^ y[yOff + yLen]);
        }
    }

    public static void xor(byte[] x, int xOff, byte[] y, int yOff, int len) {
        while (--len >= 0) {
            int n2 = xOff + len;
            x[n2] = (byte)(x[n2] ^ y[yOff + len]);
        }
    }

    public static void xor(byte[] x, byte[] y, byte[] z) {
        int n2 = 0;
        do {
            z[n2] = (byte)(x[n2] ^ y[n2]);
            z[++n2] = (byte)(x[n2] ^ y[n2]);
            z[++n2] = (byte)(x[n2] ^ y[n2]);
            z[++n2] = (byte)(x[n2] ^ y[n2]);
        } while (++n2 < 16);
    }

    public static void xor(int[] x, int[] y) {
        x[0] = x[0] ^ y[0];
        x[1] = x[1] ^ y[1];
        x[2] = x[2] ^ y[2];
        x[3] = x[3] ^ y[3];
    }

    public static void xor(int[] x, int[] y, int[] z) {
        z[0] = x[0] ^ y[0];
        z[1] = x[1] ^ y[1];
        z[2] = x[2] ^ y[2];
        z[3] = x[3] ^ y[3];
    }

    public static void xor(long[] x, long[] y) {
        x[0] = x[0] ^ y[0];
        x[1] = x[1] ^ y[1];
    }

    public static void xor(long[] x, long[] y, long[] z) {
        z[0] = x[0] ^ y[0];
        z[1] = x[1] ^ y[1];
    }

    private static long a(long l2, long l3) {
        long l4 = l2 & 0x1111111111111111L;
        long l5 = l2 & 0x2222222222222222L;
        long l6 = l2 & 0x4444444444444444L;
        long l7 = l2 & 0x8888888888888888L;
        long l8 = l3 & 0x1111111111111111L;
        long l9 = l3 & 0x2222222222222222L;
        long l10 = l3 & 0x4444444444444444L;
        long l11 = l3 & 0x8888888888888888L;
        long l12 = l4 * l8 ^ l5 * l11 ^ l6 * l10 ^ l7 * l9;
        long l13 = l4 * l9 ^ l5 * l8 ^ l6 * l11 ^ l7 * l10;
        long l14 = l4 * l10 ^ l5 * l9 ^ l6 * l8 ^ l7 * l11;
        long l15 = l4 * l11 ^ l5 * l10 ^ l6 * l9 ^ l7 * l8;
        return (l12 &= 0x1111111111111111L) | (l13 &= 0x2222222222222222L) | (l14 &= 0x4444444444444444L) | (l15 &= 0x8888888888888888L);
    }
}

