/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.params;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.util.Arrays;

public class Blake3Parameters
implements CipherParameters {
    private byte[] a;
    private byte[] b;

    public static Blake3Parameters context(byte[] pContext) {
        if (pContext == null) {
            throw new IllegalArgumentException("Invalid context");
        }
        Blake3Parameters blake3Parameters = new Blake3Parameters();
        blake3Parameters.b = Arrays.clone(pContext);
        return blake3Parameters;
    }

    public static Blake3Parameters key(byte[] pKey) {
        if (pKey == null || pKey.length != 32) {
            throw new IllegalArgumentException("Invalid keyLength");
        }
        Blake3Parameters blake3Parameters = new Blake3Parameters();
        blake3Parameters.a = Arrays.clone(pKey);
        return blake3Parameters;
    }

    public byte[] getKey() {
        return Arrays.clone(this.a);
    }

    public void clearKey() {
        Arrays.fill(this.a, (byte)0);
    }

    public byte[] getContext() {
        return Arrays.clone(this.b);
    }
}

