/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.params;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.params.DHValidationParameters;
import com.enterprisedt.bouncycastle.util.Properties;
import java.math.BigInteger;

public class DHParameters
implements CipherParameters {
    private BigInteger a;
    private BigInteger b;
    private BigInteger c;
    private BigInteger d;
    private int e;
    private int f;
    private DHValidationParameters g;

    private static int a(int n2) {
        if (n2 == 0) {
            return 160;
        }
        return n2 < 160 ? n2 : 160;
    }

    public DHParameters(BigInteger p2, BigInteger g2) {
        this(p2, g2, null, 0);
    }

    public DHParameters(BigInteger p2, BigInteger g2, BigInteger q2) {
        this(p2, g2, q2, 0);
    }

    public DHParameters(BigInteger p2, BigInteger g2, BigInteger q2, int l2) {
        this(p2, g2, q2, DHParameters.a(l2), l2, null, null);
    }

    public DHParameters(BigInteger p2, BigInteger g2, BigInteger q2, int m2, int l2) {
        this(p2, g2, q2, m2, l2, null, null);
    }

    public DHParameters(BigInteger p2, BigInteger g2, BigInteger q2, BigInteger j2, DHValidationParameters validation) {
        this(p2, g2, q2, 160, 0, j2, validation);
    }

    public DHParameters(BigInteger p2, BigInteger g2, BigInteger q2, int m2, int l2, BigInteger j2, DHValidationParameters validation) {
        if (l2 != 0) {
            if (l2 > p2.bitLength()) {
                throw new IllegalArgumentException("when l value specified, it must satisfy 2^(l-1) <= p");
            }
            if (l2 < m2) {
                throw new IllegalArgumentException("when l value specified, it may not be less than m value");
            }
        }
        if (m2 > p2.bitLength() && !Properties.isOverrideSet("com.enterprisedt.bouncycastle.dh.allow_unsafe_p_value")) {
            throw new IllegalArgumentException("unsafe p value so small specific l required");
        }
        this.a = g2;
        this.b = p2;
        this.c = q2;
        this.e = m2;
        this.f = l2;
        this.d = j2;
        this.g = validation;
    }

    public BigInteger getP() {
        return this.b;
    }

    public BigInteger getG() {
        return this.a;
    }

    public BigInteger getQ() {
        return this.c;
    }

    public BigInteger getJ() {
        return this.d;
    }

    public int getM() {
        return this.e;
    }

    public int getL() {
        return this.f;
    }

    public DHValidationParameters getValidationParameters() {
        return this.g;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DHParameters)) {
            return false;
        }
        DHParameters dHParameters = (DHParameters)obj;
        if (this.getQ() != null ? !this.getQ().equals(dHParameters.getQ()) : dHParameters.getQ() != null) {
            return false;
        }
        return dHParameters.getP().equals(this.b) && dHParameters.getG().equals(this.a);
    }

    public int hashCode() {
        return this.getP().hashCode() ^ this.getG().hashCode() ^ (this.getQ() != null ? this.getQ().hashCode() : 0);
    }
}

