/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.params;

import com.enterprisedt.bouncycastle.crypto.KeyGenerationParameters;
import java.security.SecureRandom;

public class NaccacheSternKeyGenerationParameters
extends KeyGenerationParameters {
    private int a;
    private int b;
    private boolean c = false;

    public NaccacheSternKeyGenerationParameters(SecureRandom random, int strength, int certainty, int cntSmallPrimes) {
        this(random, strength, certainty, cntSmallPrimes, false);
    }

    public NaccacheSternKeyGenerationParameters(SecureRandom random, int strength, int certainty, int cntSmallPrimes, boolean debug) {
        super(random, strength);
        this.a = certainty;
        if (cntSmallPrimes % 2 == 1) {
            throw new IllegalArgumentException("cntSmallPrimes must be a multiple of 2");
        }
        if (cntSmallPrimes < 30) {
            throw new IllegalArgumentException("cntSmallPrimes must be >= 30 for security reasons");
        }
        this.b = cntSmallPrimes;
        this.c = debug;
    }

    public int getCertainty() {
        return this.a;
    }

    public int getCntSmallPrimes() {
        return this.b;
    }

    public boolean isDebug() {
        return this.c;
    }
}

