/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.params;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECDomainParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.math.ec.FixedPointCombMultiplier;

public class SM2KeyExchangePrivateParameters
implements CipherParameters {
    private final boolean a;
    private final ECPrivateKeyParameters b;
    private final ECPoint c;
    private final ECPrivateKeyParameters d;
    private final ECPoint e;

    public SM2KeyExchangePrivateParameters(boolean initiator, ECPrivateKeyParameters staticPrivateKey, ECPrivateKeyParameters ephemeralPrivateKey) {
        if (staticPrivateKey == null) {
            throw new NullPointerException("staticPrivateKey cannot be null");
        }
        if (ephemeralPrivateKey == null) {
            throw new NullPointerException("ephemeralPrivateKey cannot be null");
        }
        ECDomainParameters eCDomainParameters = staticPrivateKey.getParameters();
        if (!eCDomainParameters.equals(ephemeralPrivateKey.getParameters())) {
            throw new IllegalArgumentException("Static and ephemeral private keys have different domain parameters");
        }
        FixedPointCombMultiplier fixedPointCombMultiplier = new FixedPointCombMultiplier();
        this.a = initiator;
        this.b = staticPrivateKey;
        this.c = fixedPointCombMultiplier.multiply(eCDomainParameters.getG(), staticPrivateKey.getD()).normalize();
        this.d = ephemeralPrivateKey;
        this.e = fixedPointCombMultiplier.multiply(eCDomainParameters.getG(), ephemeralPrivateKey.getD()).normalize();
    }

    public boolean isInitiator() {
        return this.a;
    }

    public ECPrivateKeyParameters getStaticPrivateKey() {
        return this.b;
    }

    public ECPoint getStaticPublicPoint() {
        return this.c;
    }

    public ECPrivateKeyParameters getEphemeralPrivateKey() {
        return this.d;
    }

    public ECPoint getEphemeralPublicPoint() {
        return this.e;
    }
}

