/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.params;

import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.io.Streams;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public final class X448PublicKeyParameters
extends AsymmetricKeyParameter {
    public static final int KEY_SIZE = 56;
    private final byte[] b = new byte[56];

    public X448PublicKeyParameters(byte[] buf) {
        this(X448PublicKeyParameters.a(buf), 0);
    }

    public X448PublicKeyParameters(byte[] buf, int off) {
        super(false);
        System.arraycopy(buf, off, this.b, 0, 56);
    }

    public X448PublicKeyParameters(InputStream input) throws IOException {
        super(false);
        if (56 != Streams.readFully(input, this.b)) {
            throw new EOFException("EOF encountered in middle of X448 public key");
        }
    }

    public void encode(byte[] buf, int off) {
        System.arraycopy(this.b, 0, buf, off, 56);
    }

    public byte[] getEncoded() {
        return Arrays.clone(this.b);
    }

    private static byte[] a(byte[] byArray) {
        if (byArray.length != 56) {
            throw new IllegalArgumentException("'buf' must have length 56");
        }
        return byArray;
    }
}

