/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.prng;

import com.enterprisedt.bouncycastle.crypto.prng.EntropySource;
import com.enterprisedt.bouncycastle.crypto.prng.EntropySourceProvider;
import com.enterprisedt.bouncycastle.crypto.prng.SP800SecureRandom;
import com.enterprisedt.bouncycastle.crypto.prng.X931SecureRandom;
import java.security.SecureRandom;

public class BasicEntropySourceProvider
implements EntropySourceProvider {
    private final SecureRandom a;
    private final boolean b;

    public BasicEntropySourceProvider(SecureRandom random, boolean isPredictionResistant) {
        this.a = random;
        this.b = isPredictionResistant;
    }

    @Override
    public EntropySource get(final int bitsRequired) {
        return new EntropySource(){

            @Override
            public boolean isPredictionResistant() {
                return BasicEntropySourceProvider.this.b;
            }

            @Override
            public byte[] getEntropy() {
                if (BasicEntropySourceProvider.this.a instanceof SP800SecureRandom || BasicEntropySourceProvider.this.a instanceof X931SecureRandom) {
                    byte[] byArray = new byte[(bitsRequired + 7) / 8];
                    BasicEntropySourceProvider.this.a.nextBytes(byArray);
                    return byArray;
                }
                return BasicEntropySourceProvider.this.a.generateSeed((bitsRequired + 7) / 8);
            }

            @Override
            public int entropySize() {
                return bitsRequired;
            }
        };
    }
}

