/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.prng.drbg;

import com.enterprisedt.bouncycastle.crypto.Mac;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.prng.EntropySource;
import com.enterprisedt.bouncycastle.crypto.prng.drbg.SP80090DRBG;
import com.enterprisedt.bouncycastle.crypto.prng.drbg.a;
import com.enterprisedt.bouncycastle.util.Arrays;

public class HMacSP800DRBG
implements SP80090DRBG {
    private byte[] a;
    private byte[] b;
    private long c;
    private EntropySource d;
    private Mac e;
    private int f;

    public HMacSP800DRBG(Mac hMac, int securityStrength, EntropySource entropySource, byte[] personalizationString, byte[] nonce) {
        if (securityStrength > com.enterprisedt.bouncycastle.crypto.prng.drbg.a.a(hMac)) {
            throw new IllegalArgumentException("Requested security strength is not supported by the derivation function");
        }
        if (entropySource.entropySize() < securityStrength) {
            throw new IllegalArgumentException("Not enough entropy for security strength required");
        }
        this.f = securityStrength;
        this.d = entropySource;
        this.e = hMac;
        byte[] byArray = this.a();
        byte[] byArray2 = Arrays.concatenate(byArray, nonce, personalizationString);
        this.a = new byte[hMac.getMacSize()];
        this.b = new byte[this.a.length];
        Arrays.fill(this.b, (byte)1);
        this.a(byArray2);
        this.c = 1L;
    }

    private void a(byte[] byArray) {
        this.a(byArray, (byte)0);
        if (byArray != null) {
            this.a(byArray, (byte)1);
        }
    }

    private void a(byte[] byArray, byte by) {
        this.e.init(new KeyParameter(this.a));
        this.e.update(this.b, 0, this.b.length);
        this.e.update(by);
        if (byArray != null) {
            this.e.update(byArray, 0, byArray.length);
        }
        this.e.doFinal(this.a, 0);
        this.e.init(new KeyParameter(this.a));
        this.e.update(this.b, 0, this.b.length);
        this.e.doFinal(this.b, 0);
    }

    @Override
    public int getBlockSize() {
        return this.b.length * 8;
    }

    @Override
    public int generate(byte[] output, byte[] additionalInput, boolean predictionResistant) {
        int n2 = output.length * 8;
        if (n2 > 262144) {
            throw new IllegalArgumentException("Number of bits per request limited to 262144");
        }
        if (this.c > 0x800000000000L) {
            return -1;
        }
        if (predictionResistant) {
            this.reseed(additionalInput);
            additionalInput = null;
        }
        if (additionalInput != null) {
            this.a(additionalInput);
        }
        byte[] byArray = new byte[output.length];
        int n3 = output.length / this.b.length;
        this.e.init(new KeyParameter(this.a));
        for (int i2 = 0; i2 < n3; ++i2) {
            this.e.update(this.b, 0, this.b.length);
            this.e.doFinal(this.b, 0);
            System.arraycopy(this.b, 0, byArray, i2 * this.b.length, this.b.length);
        }
        if (n3 * this.b.length < byArray.length) {
            this.e.update(this.b, 0, this.b.length);
            this.e.doFinal(this.b, 0);
            System.arraycopy(this.b, 0, byArray, n3 * this.b.length, byArray.length - n3 * this.b.length);
        }
        this.a(additionalInput);
        ++this.c;
        System.arraycopy(byArray, 0, output, 0, output.length);
        return n2;
    }

    @Override
    public void reseed(byte[] additionalInput) {
        byte[] byArray = this.a();
        byte[] byArray2 = Arrays.concatenate(byArray, additionalInput);
        this.a(byArray2);
        this.c = 1L;
    }

    private byte[] a() {
        byte[] byArray = this.d.getEntropy();
        if (byArray.length < (this.f + 7) / 8) {
            throw new IllegalStateException("Insufficient entropy provided by entropy source");
        }
        return byArray;
    }
}

