/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.prng.drbg;

import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.prng.EntropySource;
import com.enterprisedt.bouncycastle.crypto.prng.drbg.SP80090DRBG;
import com.enterprisedt.bouncycastle.crypto.prng.drbg.a;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Integers;
import java.util.Hashtable;

public class HashSP800DRBG
implements SP80090DRBG {
    private static final byte[] a = new byte[]{1};
    private static final Hashtable b = new Hashtable();
    private Digest c;
    private byte[] d;
    private byte[] e;
    private long f;
    private EntropySource g;
    private int h;
    private int i;

    public HashSP800DRBG(Digest digest, int securityStrength, EntropySource entropySource, byte[] personalizationString, byte[] nonce) {
        if (securityStrength > com.enterprisedt.bouncycastle.crypto.prng.drbg.a.a(digest)) {
            throw new IllegalArgumentException("Requested security strength is not supported by the derivation function");
        }
        if (entropySource.entropySize() < securityStrength) {
            throw new IllegalArgumentException("Not enough entropy for security strength required");
        }
        this.c = digest;
        this.g = entropySource;
        this.h = securityStrength;
        this.i = (Integer)b.get(digest.getAlgorithmName());
        byte[] byArray = this.a();
        byte[] byArray2 = Arrays.concatenate(byArray, nonce, personalizationString);
        byte[] byArray3 = com.enterprisedt.bouncycastle.crypto.prng.drbg.a.a(this.c, byArray2, this.i);
        this.d = byArray3;
        byte[] byArray4 = new byte[this.d.length + 1];
        System.arraycopy(this.d, 0, byArray4, 1, this.d.length);
        this.e = com.enterprisedt.bouncycastle.crypto.prng.drbg.a.a(this.c, byArray4, this.i);
        this.f = 1L;
    }

    @Override
    public int getBlockSize() {
        return this.c.getDigestSize() * 8;
    }

    @Override
    public int generate(byte[] output, byte[] additionalInput, boolean predictionResistant) {
        byte[] byArray;
        byte[] byArray2;
        int n2 = output.length * 8;
        if (n2 > 262144) {
            throw new IllegalArgumentException("Number of bits per request limited to 262144");
        }
        if (this.f > 0x800000000000L) {
            return -1;
        }
        if (predictionResistant) {
            this.reseed(additionalInput);
            additionalInput = null;
        }
        if (additionalInput != null) {
            byArray2 = new byte[1 + this.d.length + additionalInput.length];
            byArray2[0] = 2;
            System.arraycopy(this.d, 0, byArray2, 1, this.d.length);
            System.arraycopy(additionalInput, 0, byArray2, 1 + this.d.length, additionalInput.length);
            byArray = this.a(byArray2);
            this.a(this.d, byArray);
        }
        byArray2 = this.a(this.d, n2);
        byArray = new byte[this.d.length + 1];
        System.arraycopy(this.d, 0, byArray, 1, this.d.length);
        byArray[0] = 3;
        byte[] byArray3 = this.a(byArray);
        this.a(this.d, byArray3);
        this.a(this.d, this.e);
        byte[] byArray4 = new byte[]{(byte)(this.f >> 24), (byte)(this.f >> 16), (byte)(this.f >> 8), (byte)this.f};
        this.a(this.d, byArray4);
        ++this.f;
        System.arraycopy(byArray2, 0, output, 0, output.length);
        return n2;
    }

    private byte[] a() {
        byte[] byArray = this.g.getEntropy();
        if (byArray.length < (this.h + 7) / 8) {
            throw new IllegalStateException("Insufficient entropy provided by entropy source");
        }
        return byArray;
    }

    private void a(byte[] byArray, byte[] byArray2) {
        int n2;
        int n3;
        int n4 = 0;
        for (n3 = 1; n3 <= byArray2.length; ++n3) {
            n2 = (byArray[byArray.length - n3] & 0xFF) + (byArray2[byArray2.length - n3] & 0xFF) + n4;
            n4 = n2 > 255 ? 1 : 0;
            byArray[byArray.length - n3] = (byte)n2;
        }
        for (n3 = byArray2.length + 1; n3 <= byArray.length; ++n3) {
            n2 = (byArray[byArray.length - n3] & 0xFF) + n4;
            n4 = n2 > 255 ? 1 : 0;
            byArray[byArray.length - n3] = (byte)n2;
        }
    }

    @Override
    public void reseed(byte[] additionalInput) {
        byte[] byArray = this.a();
        byte[] byArray2 = Arrays.concatenate(a, this.d, byArray, additionalInput);
        byte[] byArray3 = com.enterprisedt.bouncycastle.crypto.prng.drbg.a.a(this.c, byArray2, this.i);
        this.d = byArray3;
        byte[] byArray4 = new byte[this.d.length + 1];
        byArray4[0] = 0;
        System.arraycopy(this.d, 0, byArray4, 1, this.d.length);
        this.e = com.enterprisedt.bouncycastle.crypto.prng.drbg.a.a(this.c, byArray4, this.i);
        this.f = 1L;
    }

    private byte[] a(byte[] byArray) {
        byte[] byArray2 = new byte[this.c.getDigestSize()];
        this.b(byArray, byArray2);
        return byArray2;
    }

    private void b(byte[] byArray, byte[] byArray2) {
        this.c.update(byArray, 0, byArray.length);
        this.c.doFinal(byArray2, 0);
    }

    private byte[] a(byte[] byArray, int n2) {
        int n3 = this.c.getDigestSize();
        int n4 = n2 / 8 / n3;
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byte[] byArray3 = new byte[n2 / 8];
        byte[] byArray4 = new byte[this.c.getDigestSize()];
        for (int i2 = 0; i2 <= n4; ++i2) {
            this.b(byArray2, byArray4);
            int n5 = byArray3.length - i2 * byArray4.length > byArray4.length ? byArray4.length : byArray3.length - i2 * byArray4.length;
            System.arraycopy(byArray4, 0, byArray3, i2 * byArray4.length, n5);
            this.a(byArray2, a);
        }
        return byArray3;
    }

    static {
        b.put("SHA-1", Integers.valueOf(440));
        b.put("SHA-224", Integers.valueOf(440));
        b.put("SHA-256", Integers.valueOf(440));
        b.put("SHA-512/256", Integers.valueOf(440));
        b.put("SHA-512/224", Integers.valueOf(440));
        b.put("SHA-384", Integers.valueOf(888));
        b.put("SHA-512", Integers.valueOf(888));
    }
}

