/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.signers;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.Signer;
import com.enterprisedt.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.ByteArrayOutputStream;

public class Ed25519ctxSigner
implements Signer {
    private final a a = new a();
    private final byte[] b;
    private boolean c;
    private Ed25519PrivateKeyParameters d;
    private Ed25519PublicKeyParameters e;

    public Ed25519ctxSigner(byte[] context) {
        if (null == context) {
            throw new NullPointerException("'context' cannot be null");
        }
        this.b = Arrays.clone(context);
    }

    @Override
    public void init(boolean forSigning, CipherParameters parameters) {
        this.c = forSigning;
        if (forSigning) {
            this.d = (Ed25519PrivateKeyParameters)parameters;
            this.e = null;
        } else {
            this.d = null;
            this.e = (Ed25519PublicKeyParameters)parameters;
        }
        CryptoServicesRegistrar.checkConstraints(com.enterprisedt.bouncycastle.crypto.signers.a.a("Ed25519", 128, parameters, forSigning));
        this.reset();
    }

    @Override
    public void update(byte b2) {
        this.a.write(b2);
    }

    @Override
    public void update(byte[] buf, int off, int len) {
        this.a.write(buf, off, len);
    }

    @Override
    public byte[] generateSignature() {
        if (!this.c || null == this.d) {
            throw new IllegalStateException("Ed25519ctxSigner not initialised for signature generation.");
        }
        return this.a.a(this.d, this.b);
    }

    @Override
    public boolean verifySignature(byte[] signature) {
        if (this.c || null == this.e) {
            throw new IllegalStateException("Ed25519ctxSigner not initialised for verification");
        }
        return this.a.a(this.e, this.b, signature);
    }

    @Override
    public void reset() {
        this.a.reset();
    }

    private static final class a
    extends ByteArrayOutputStream {
        private a() {
        }

        synchronized byte[] a(Ed25519PrivateKeyParameters ed25519PrivateKeyParameters, byte[] byArray) {
            byte[] byArray2 = new byte[64];
            ed25519PrivateKeyParameters.sign(1, byArray, this.buf, 0, this.count, byArray2, 0);
            this.reset();
            return byArray2;
        }

        synchronized boolean a(Ed25519PublicKeyParameters ed25519PublicKeyParameters, byte[] byArray, byte[] byArray2) {
            if (64 != byArray2.length) {
                this.reset();
                return false;
            }
            boolean bl = ed25519PublicKeyParameters.verify(1, byArray, this.buf, 0, this.count, byArray2, 0);
            this.reset();
            return bl;
        }

        @Override
        public synchronized void reset() {
            Arrays.fill(this.buf, 0, this.count, (byte)0);
            this.count = 0;
        }
    }
}

