/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.signers;

import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.macs.HMac;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.signers.DSAKCalculator;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class HMacDSAKCalculator
implements DSAKCalculator {
    private static final BigInteger a = BigInteger.valueOf(0L);
    private final HMac b;
    private final byte[] c;
    private final byte[] d;
    private BigInteger e;

    public HMacDSAKCalculator(Digest digest) {
        this.b = new HMac(digest);
        this.d = new byte[this.b.getMacSize()];
        this.c = new byte[this.b.getMacSize()];
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public void init(BigInteger n2, SecureRandom random) {
        throw new IllegalStateException("Operation not supported");
    }

    @Override
    public void init(BigInteger n2, BigInteger d2, byte[] message) {
        this.e = n2;
        Arrays.fill(this.d, (byte)1);
        Arrays.fill(this.c, (byte)0);
        int n3 = BigIntegers.getUnsignedByteLength(n2);
        byte[] byArray = new byte[n3];
        byte[] byArray2 = BigIntegers.asUnsignedByteArray(d2);
        System.arraycopy(byArray2, 0, byArray, byArray.length - byArray2.length, byArray2.length);
        byte[] byArray3 = new byte[n3];
        BigInteger bigInteger = this.a(message);
        if (bigInteger.compareTo(n2) >= 0) {
            bigInteger = bigInteger.subtract(n2);
        }
        byte[] byArray4 = BigIntegers.asUnsignedByteArray(bigInteger);
        System.arraycopy(byArray4, 0, byArray3, byArray3.length - byArray4.length, byArray4.length);
        this.b.init(new KeyParameter(this.c));
        this.b.update(this.d, 0, this.d.length);
        this.b.update((byte)0);
        this.b.update(byArray, 0, byArray.length);
        this.b.update(byArray3, 0, byArray3.length);
        this.initAdditionalInput0(this.b);
        this.b.doFinal(this.c, 0);
        this.b.init(new KeyParameter(this.c));
        this.b.update(this.d, 0, this.d.length);
        this.b.doFinal(this.d, 0);
        this.b.update(this.d, 0, this.d.length);
        this.b.update((byte)1);
        this.b.update(byArray, 0, byArray.length);
        this.b.update(byArray3, 0, byArray3.length);
        this.b.doFinal(this.c, 0);
        this.b.init(new KeyParameter(this.c));
        this.b.update(this.d, 0, this.d.length);
        this.b.doFinal(this.d, 0);
    }

    @Override
    public BigInteger nextK() {
        byte[] byArray = new byte[BigIntegers.getUnsignedByteLength(this.e)];
        while (true) {
            int n2;
            for (int i2 = 0; i2 < byArray.length; i2 += n2) {
                this.b.update(this.d, 0, this.d.length);
                this.b.doFinal(this.d, 0);
                n2 = Math.min(byArray.length - i2, this.d.length);
                System.arraycopy(this.d, 0, byArray, i2, n2);
            }
            BigInteger bigInteger = this.a(byArray);
            if (bigInteger.compareTo(a) > 0 && bigInteger.compareTo(this.e) < 0) {
                return bigInteger;
            }
            this.b.update(this.d, 0, this.d.length);
            this.b.update((byte)0);
            this.b.doFinal(this.c, 0);
            this.b.init(new KeyParameter(this.c));
            this.b.update(this.d, 0, this.d.length);
            this.b.doFinal(this.d, 0);
        }
    }

    protected void initAdditionalInput0(HMac hmac0) {
    }

    private BigInteger a(byte[] byArray) {
        BigInteger bigInteger = new BigInteger(1, byArray);
        if (byArray.length * 8 > this.e.bitLength()) {
            bigInteger = bigInteger.shiftRight(byArray.length * 8 - this.e.bitLength());
        }
        return bigInteger;
    }
}

