/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec;

import com.enterprisedt.bouncycastle.math.ec.AbstractECMultiplier;
import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import com.enterprisedt.bouncycastle.math.ec.ECLookupTable;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.math.ec.FixedPointPreCompInfo;
import com.enterprisedt.bouncycastle.math.ec.FixedPointUtil;
import com.enterprisedt.bouncycastle.math.raw.Nat;
import java.math.BigInteger;

public class FixedPointCombMultiplier
extends AbstractECMultiplier {
    @Override
    protected ECPoint multiplyPositive(ECPoint p2, BigInteger k2) {
        ECCurve eCCurve = p2.getCurve();
        int n2 = FixedPointUtil.getCombSize(eCCurve);
        if (k2.bitLength() > n2) {
            throw new IllegalStateException("fixed-point comb doesn't support scalars larger than the curve order");
        }
        FixedPointPreCompInfo fixedPointPreCompInfo = FixedPointUtil.precompute(p2);
        ECLookupTable eCLookupTable = fixedPointPreCompInfo.getLookupTable();
        int n3 = fixedPointPreCompInfo.getWidth();
        int n4 = (n2 + n3 - 1) / n3;
        ECPoint eCPoint = eCCurve.getInfinity();
        int n5 = n4 * n3;
        int[] nArray = Nat.fromBigInteger(n5, k2);
        int n6 = n5 - 1;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n7 = 0;
            for (int i3 = n6 - i2; i3 >= 0; i3 -= n4) {
                int n8 = nArray[i3 >>> 5] >>> (i3 & 0x1F);
                n7 ^= n8 >>> 1;
                n7 <<= 1;
                n7 ^= n8;
            }
            ECPoint eCPoint2 = eCLookupTable.lookup(n7);
            eCPoint = eCPoint.twicePlus(eCPoint2);
        }
        return eCPoint.add(fixedPointPreCompInfo.getOffset());
    }
}

