/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec;

import com.enterprisedt.bouncycastle.math.ec.AbstractECMultiplier;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.math.ec.WNafPreCompInfo;
import com.enterprisedt.bouncycastle.math.ec.WNafUtil;
import com.enterprisedt.bouncycastle.util.Integers;
import java.math.BigInteger;

public class WNafL2RMultiplier
extends AbstractECMultiplier {
    @Override
    protected ECPoint multiplyPositive(ECPoint p2, BigInteger k2) {
        ECPoint[] eCPointArray;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = WNafUtil.getWindowSize(k2.bitLength());
        WNafPreCompInfo wNafPreCompInfo = WNafUtil.precompute(p2, n6, true);
        ECPoint[] eCPointArray2 = wNafPreCompInfo.getPreComp();
        ECPoint[] eCPointArray3 = wNafPreCompInfo.getPreCompNeg();
        int n7 = wNafPreCompInfo.getWidth();
        int[] nArray = WNafUtil.generateCompactWindowNaf(n7, k2);
        ECPoint eCPoint = p2.getCurve().getInfinity();
        int n8 = nArray.length;
        if (n8 > 1) {
            n5 = nArray[--n8];
            n4 = n5 >> 16;
            n3 = n5 & 0xFFFF;
            n2 = Math.abs(n4);
            ECPoint[] eCPointArray4 = eCPointArray = n4 < 0 ? eCPointArray3 : eCPointArray2;
            if (n2 << 2 < 1 << n7) {
                int n9 = 32 - Integers.numberOfLeadingZeros(n2);
                int n10 = n7 - n9;
                int n11 = n2 ^ 1 << n9 - 1;
                int n12 = (1 << n7 - 1) - 1;
                int n13 = (n11 << n10) + 1;
                eCPoint = eCPointArray[n12 >>> 1].add(eCPointArray[n13 >>> 1]);
                n3 -= n10;
            } else {
                eCPoint = eCPointArray[n2 >>> 1];
            }
            eCPoint = eCPoint.timesPow2(n3);
        }
        while (n8 > 0) {
            n5 = nArray[--n8];
            n4 = n5 >> 16;
            n3 = n5 & 0xFFFF;
            n2 = Math.abs(n4);
            eCPointArray = n4 < 0 ? eCPointArray3 : eCPointArray2;
            ECPoint eCPoint2 = eCPointArray[n2 >>> 1];
            eCPoint = eCPoint.twicePlus(eCPoint2);
            eCPoint = eCPoint.timesPow2(n3);
        }
        return eCPoint;
    }
}

