/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.djb;

import com.enterprisedt.bouncycastle.math.ec.AbstractECLookupTable;
import com.enterprisedt.bouncycastle.math.ec.ECConstants;
import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import com.enterprisedt.bouncycastle.math.ec.ECFieldElement;
import com.enterprisedt.bouncycastle.math.ec.ECLookupTable;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.math.ec.custom.djb.Curve25519Field;
import com.enterprisedt.bouncycastle.math.ec.custom.djb.Curve25519FieldElement;
import com.enterprisedt.bouncycastle.math.ec.custom.djb.Curve25519Point;
import com.enterprisedt.bouncycastle.math.raw.Nat256;
import com.enterprisedt.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;
import java.security.SecureRandom;

public class Curve25519
extends ECCurve.AbstractFp {
    public static final BigInteger q = Curve25519FieldElement.Q;
    private static final BigInteger c = new BigInteger(1, Hex.decodeStrict("2AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA984914A144"));
    private static final BigInteger d = new BigInteger(1, Hex.decodeStrict("7B425ED097B425ED097B425ED097B425ED097B425ED097B4260B5E9C7710C864"));
    private static final ECFieldElement[] e = new ECFieldElement[]{new Curve25519FieldElement(ECConstants.ONE), new Curve25519FieldElement(c)};
    protected Curve25519Point infinity = new Curve25519Point(this, null, null);

    public Curve25519() {
        super(q);
        this.a = this.fromBigInteger(c);
        this.b = this.fromBigInteger(d);
        this.order = new BigInteger(1, Hex.decodeStrict("1000000000000000000000000000000014DEF9DEA2F79CD65812631A5CF5D3ED"));
        this.cofactor = BigInteger.valueOf(8L);
        this.coord = 4;
    }

    @Override
    protected ECCurve cloneCurve() {
        return new Curve25519();
    }

    @Override
    public boolean supportsCoordinateSystem(int coord) {
        switch (coord) {
            case 4: {
                return true;
            }
        }
        return false;
    }

    public BigInteger getQ() {
        return q;
    }

    @Override
    public int getFieldSize() {
        return q.bitLength();
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger x) {
        return new Curve25519FieldElement(x);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y) {
        return new Curve25519Point(this, x, y);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y, ECFieldElement[] zs) {
        return new Curve25519Point(this, x, y, zs);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] points, int off, final int len) {
        int n2 = 8;
        final int[] nArray = new int[len * 8 * 2];
        int n3 = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            ECPoint eCPoint = points[off + i2];
            Nat256.copy(((Curve25519FieldElement)eCPoint.getRawXCoord()).x, 0, nArray, n3);
            Nat256.copy(((Curve25519FieldElement)eCPoint.getRawYCoord()).x, 0, nArray, n3 += 8);
            n3 += 8;
        }
        return new AbstractECLookupTable(){

            @Override
            public int getSize() {
                return len;
            }

            @Override
            public ECPoint lookup(int index) {
                int[] nArray3 = Nat256.create();
                int[] nArray2 = Nat256.create();
                int n2 = 0;
                for (int i2 = 0; i2 < len; ++i2) {
                    int n3 = (i2 ^ index) - 1 >> 31;
                    for (int i3 = 0; i3 < 8; ++i3) {
                        int n4 = i3;
                        nArray3[n4] = nArray3[n4] ^ nArray[n2 + i3] & n3;
                        int n5 = i3;
                        nArray2[n5] = nArray2[n5] ^ nArray[n2 + 8 + i3] & n3;
                    }
                    n2 += 16;
                }
                return this.a(nArray3, nArray2);
            }

            @Override
            public ECPoint lookupVar(int index) {
                int[] nArray3 = Nat256.create();
                int[] nArray2 = Nat256.create();
                int n2 = index * 8 * 2;
                for (int i2 = 0; i2 < 8; ++i2) {
                    nArray3[i2] = nArray[n2 + i2];
                    nArray2[i2] = nArray[n2 + 8 + i2];
                }
                return this.a(nArray3, nArray2);
            }

            private ECPoint a(int[] nArray3, int[] nArray2) {
                return Curve25519.this.createRawPoint(new Curve25519FieldElement(nArray3), new Curve25519FieldElement(nArray2), e);
            }
        };
    }

    @Override
    public ECFieldElement randomFieldElement(SecureRandom r2) {
        int[] nArray = Nat256.create();
        Curve25519Field.random(r2, nArray);
        return new Curve25519FieldElement(nArray);
    }

    @Override
    public ECFieldElement randomFieldElementMult(SecureRandom r2) {
        int[] nArray = Nat256.create();
        Curve25519Field.randomMult(r2, nArray);
        return new Curve25519FieldElement(nArray);
    }
}

