/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.raw.Mod;
import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.math.raw.Nat128;
import com.enterprisedt.bouncycastle.math.raw.Nat256;
import com.enterprisedt.bouncycastle.util.Pack;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SecP128R1Field {
    static final int[] a = new int[]{-1, -1, -1, -3};
    private static final int[] b = new int[]{1, 0, 0, 4, -2, -1, 3, -4};
    private static final int[] c = new int[]{-1, -1, -1, -5, 1, 0, -4, 3};

    public static void add(int[] x, int[] y, int[] z) {
        int n2 = Nat128.add(x, y, z);
        if (n2 != 0 || z[3] >>> 1 >= 0x7FFFFFFE && Nat128.gte(z, a)) {
            SecP128R1Field.a(z);
        }
    }

    public static void addExt(int[] xx, int[] yy, int[] zz) {
        int n2 = Nat256.add(xx, yy, zz);
        if (n2 != 0 || zz[7] >>> 1 >= 0x7FFFFFFE && Nat256.gte(zz, b)) {
            Nat.addTo(c.length, c, zz);
        }
    }

    public static void addOne(int[] x, int[] z) {
        int n2 = Nat.inc(4, x, z);
        if (n2 != 0 || z[3] >>> 1 >= 0x7FFFFFFE && Nat128.gte(z, a)) {
            SecP128R1Field.a(z);
        }
    }

    public static int[] fromBigInteger(BigInteger x) {
        int[] nArray = Nat128.fromBigInteger(x);
        if (nArray[3] >>> 1 >= 0x7FFFFFFE && Nat128.gte(nArray, a)) {
            Nat128.subFrom(a, nArray);
        }
        return nArray;
    }

    public static void half(int[] x, int[] z) {
        if ((x[0] & 1) == 0) {
            Nat.shiftDownBit(4, x, 0, z);
        } else {
            int n2 = Nat128.add(x, a, z);
            Nat.shiftDownBit(4, z, n2);
        }
    }

    public static void inv(int[] x, int[] z) {
        Mod.checkedModOddInverse(a, x, z);
    }

    public static int isZero(int[] x) {
        int n2 = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            n2 |= x[i2];
        }
        n2 = n2 >>> 1 | n2 & 1;
        return n2 - 1 >> 31;
    }

    public static void multiply(int[] x, int[] y, int[] z) {
        int[] nArray = Nat128.createExt();
        Nat128.mul(x, y, nArray);
        SecP128R1Field.reduce(nArray, z);
    }

    public static void multiplyAddToExt(int[] x, int[] y, int[] zz) {
        int n2 = Nat128.mulAddTo(x, y, zz);
        if (n2 != 0 || zz[7] >>> 1 >= 0x7FFFFFFE && Nat256.gte(zz, b)) {
            Nat.addTo(c.length, c, zz);
        }
    }

    public static void negate(int[] x, int[] z) {
        if (0 != SecP128R1Field.isZero(x)) {
            Nat128.sub(a, a, z);
        } else {
            Nat128.sub(a, x, z);
        }
    }

    public static void random(SecureRandom r2, int[] z) {
        byte[] byArray = new byte[16];
        do {
            r2.nextBytes(byArray);
            Pack.littleEndianToInt(byArray, 0, z, 0, 4);
        } while (0 == Nat.lessThan(4, z, a));
    }

    public static void randomMult(SecureRandom r2, int[] z) {
        do {
            SecP128R1Field.random(r2, z);
        } while (0 != SecP128R1Field.isZero(z));
    }

    public static void reduce(int[] xx, int[] z) {
        long l2 = (long)xx[0] & 0xFFFFFFFFL;
        long l3 = (long)xx[1] & 0xFFFFFFFFL;
        long l4 = (long)xx[2] & 0xFFFFFFFFL;
        long l5 = (long)xx[3] & 0xFFFFFFFFL;
        long l6 = (long)xx[4] & 0xFFFFFFFFL;
        long l7 = (long)xx[5] & 0xFFFFFFFFL;
        long l8 = (long)xx[6] & 0xFFFFFFFFL;
        long l9 = (long)xx[7] & 0xFFFFFFFFL;
        l5 += l9;
        l4 += (l8 += l9 << 1);
        l3 += (l7 += l8 << 1);
        l5 += l6 << 1;
        z[0] = (int)(l2 += (l6 += l7 << 1));
        z[1] = (int)(l3 += l2 >>> 32);
        z[2] = (int)(l4 += l3 >>> 32);
        z[3] = (int)(l5 += l4 >>> 32);
        SecP128R1Field.reduce32((int)(l5 >>> 32), z);
    }

    public static void reduce32(int x, int[] z) {
        while (x != 0) {
            long l2 = (long)x & 0xFFFFFFFFL;
            long l3 = ((long)z[0] & 0xFFFFFFFFL) + l2;
            z[0] = (int)l3;
            if ((l3 >>= 32) != 0L) {
                z[1] = (int)(l3 += (long)z[1] & 0xFFFFFFFFL);
                l3 >>= 32;
                z[2] = (int)(l3 += (long)z[2] & 0xFFFFFFFFL);
                l3 >>= 32;
            }
            z[3] = (int)(l3 += ((long)z[3] & 0xFFFFFFFFL) + (l2 << 1));
            x = (int)(l3 >>= 32);
        }
        if (z[3] >>> 1 >= 0x7FFFFFFE && Nat128.gte(z, a)) {
            SecP128R1Field.a(z);
        }
    }

    public static void square(int[] x, int[] z) {
        int[] nArray = Nat128.createExt();
        Nat128.square(x, nArray);
        SecP128R1Field.reduce(nArray, z);
    }

    public static void squareN(int[] x, int n2, int[] z) {
        int[] nArray = Nat128.createExt();
        Nat128.square(x, nArray);
        SecP128R1Field.reduce(nArray, z);
        while (--n2 > 0) {
            Nat128.square(z, nArray);
            SecP128R1Field.reduce(nArray, z);
        }
    }

    public static void subtract(int[] x, int[] y, int[] z) {
        int n2 = Nat128.sub(x, y, z);
        if (n2 != 0) {
            SecP128R1Field.b(z);
        }
    }

    public static void subtractExt(int[] xx, int[] yy, int[] zz) {
        int n2 = Nat.sub(10, xx, yy, zz);
        if (n2 != 0) {
            Nat.subFrom(c.length, c, zz);
        }
    }

    public static void twice(int[] x, int[] z) {
        int n2 = Nat.shiftUpBit(4, x, 0, z);
        if (n2 != 0 || z[3] >>> 1 >= 0x7FFFFFFE && Nat128.gte(z, a)) {
            SecP128R1Field.a(z);
        }
    }

    private static void a(int[] nArray) {
        long l2 = ((long)nArray[0] & 0xFFFFFFFFL) + 1L;
        nArray[0] = (int)l2;
        if ((l2 >>= 32) != 0L) {
            nArray[1] = (int)(l2 += (long)nArray[1] & 0xFFFFFFFFL);
            l2 >>= 32;
            nArray[2] = (int)(l2 += (long)nArray[2] & 0xFFFFFFFFL);
            l2 >>= 32;
        }
        nArray[3] = (int)(l2 += ((long)nArray[3] & 0xFFFFFFFFL) + 2L);
    }

    private static void b(int[] nArray) {
        long l2 = ((long)nArray[0] & 0xFFFFFFFFL) - 1L;
        nArray[0] = (int)l2;
        if ((l2 >>= 32) != 0L) {
            nArray[1] = (int)(l2 += (long)nArray[1] & 0xFFFFFFFFL);
            l2 >>= 32;
            nArray[2] = (int)(l2 += (long)nArray[2] & 0xFFFFFFFFL);
            l2 >>= 32;
        }
        nArray[3] = (int)(l2 += ((long)nArray[3] & 0xFFFFFFFFL) - 2L);
    }
}

